/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.hardware.util;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.helpers.KnownMonitorType;
import org.sentrysoftware.metricshub.engine.strategy.utils.CollectHelper;
import org.sentrysoftware.metricshub.engine.telemetry.MetricFactory;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.hardware.sustainability.HardwarePowerAndEnergyEstimator;
import org.sentrysoftware.metricshub.hardware.sustainability.HostMonitorPowerAndEnergyEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerAndEnergyCollectHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PowerAndEnergyCollectHelper.class);

    public static void collectPowerAndEnergy(Monitor monitor, String powerMetricName, String energyMetricName, TelemetryManager telemetryManager, HardwarePowerAndEnergyEstimator hardwarePowerAndEnergyEstimator) {
        Double estimatedPower = hardwarePowerAndEnergyEstimator.estimatePower();
        if (estimatedPower == null) {
            log.warn("Hostname {} - Received null value for power consumption. Consequently, the metric '{}' will not be collected on monitor '{}' (ID: {})", telemetryManager.getHostname(), powerMetricName, monitor.getType(), monitor.getId());
            return;
        }
        MetricFactory metricFactory = new MetricFactory(telemetryManager.getHostname());
        metricFactory.collectNumberMetric(monitor, powerMetricName, estimatedPower, telemetryManager.getStrategyTime());
        Double estimatedEnergy = hardwarePowerAndEnergyEstimator.estimateEnergy();
        if (estimatedEnergy == null) {
            log.info("Hostname {} - Received null value for energy. Consequently, the metric '{}' will not be collected during this cycle on monitor '{}' (ID: {})", telemetryManager.getHostname(), energyMetricName, monitor.getType(), monitor.getId());
            return;
        }
        metricFactory.collectNumberMetric(monitor, energyMetricName, estimatedEnergy, telemetryManager.getStrategyTime());
    }

    public static boolean collectHostPowerAndEnergy(Monitor monitor, TelemetryManager telemetryManager, HostMonitorPowerAndEnergyEstimator hostMonitorEnergyAndPowerEstimator) {
        Map<String, Monitor> enclosures = telemetryManager.findMonitorsByType(KnownMonitorType.ENCLOSURE.getKey());
        MetricFactory metricFactory = new MetricFactory(telemetryManager.getHostname());
        if (PowerAndEnergyCollectHelper.isPowerMeasured(enclosures)) {
            Double computedPower = hostMonitorEnergyAndPowerEstimator.computeMeasuredPower();
            if (PowerAndEnergyCollectHelper.isNullComputedPower(telemetryManager, monitor, "hw.host.power{quality=\"measured\"}", computedPower)) {
                return true;
            }
            metricFactory.collectNumberMetric(monitor, "hw.host.power{quality=\"measured\"}", computedPower, telemetryManager.getStrategyTime());
            Double computedEnergy = hostMonitorEnergyAndPowerEstimator.computeMeasuredEnergy();
            if (PowerAndEnergyCollectHelper.isNullComputedEnergy(telemetryManager, monitor, "hw.host.energy{quality=\"measured\"}", computedEnergy)) {
                return true;
            }
            metricFactory.collectNumberMetric(monitor, "hw.host.energy{quality=\"measured\"}", computedEnergy, telemetryManager.getStrategyTime());
            return true;
        }
        Double computedPower = hostMonitorEnergyAndPowerEstimator.computeEstimatedPower();
        if (PowerAndEnergyCollectHelper.isNullComputedPower(telemetryManager, monitor, "hw.host.power{quality=\"estimated\"}", computedPower)) {
            return false;
        }
        metricFactory.collectNumberMetric(monitor, "hw.host.power{quality=\"estimated\"}", computedPower, telemetryManager.getStrategyTime());
        Double computedEnergy = hostMonitorEnergyAndPowerEstimator.computeEstimatedEnergy();
        if (PowerAndEnergyCollectHelper.isNullComputedEnergy(telemetryManager, monitor, "hw.host.energy{quality=\"estimated\"}", computedEnergy)) {
            return false;
        }
        metricFactory.collectNumberMetric(monitor, "hw.host.energy{quality=\"estimated\"}", computedEnergy, telemetryManager.getStrategyTime());
        return false;
    }

    static boolean isNullComputedPower(TelemetryManager telemetryManager, Monitor monitor, String powerMetricName, Double computedPower) {
        if (computedPower == null) {
            log.warn("Hostname {} - Received null value for power consumption. Consequently, the metric '{}' will not be collected on monitor '{}' (ID: {})", telemetryManager.getHostname(), powerMetricName, monitor.getType(), monitor.getId());
            return true;
        }
        return false;
    }

    static boolean isNullComputedEnergy(TelemetryManager telemetryManager, Monitor monitor, String energyMetricName, Double computedEnergy) {
        if (computedEnergy == null) {
            log.info("Hostname {} - Received null value for energy. Consequently, the metric '{}' will not be collected during this cycle on monitor '{}' (ID: {})", telemetryManager.getHostname(), energyMetricName, monitor.getType(), monitor.getId());
            return true;
        }
        return false;
    }

    private static boolean isPowerMeasured(Map<String, Monitor> enclosures) {
        return Optional.ofNullable(enclosures).stream().map(Map::values).flatMap(Collection::stream).anyMatch(monitor -> CollectHelper.getUpdatedNumberMetricValue(monitor, "hw.enclosure.power") != null || CollectHelper.getUpdatedNumberMetricValue(monitor, "hw.enclosure.energy") != null);
    }

    @Generated
    private PowerAndEnergyCollectHelper() {
    }
}

