/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.xflat.handlers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.sentrysoftware.xflat.Utils;

public class ResultHandler {
    static final String LINK_SEPARATOR = "=>";
    static final int ROOT_TAG_NOT_FOUND = -1;

    private ResultHandler() {
    }

    public static List<List<String>> arrange(Map<String, Map<Integer, String>> rowValuesMap, int totalProperties) {
        if (null == rowValuesMap || rowValuesMap.isEmpty()) {
            return new ArrayList<List<String>>();
        }
        List<Map<Integer, String>> linkedRows = ResultHandler.recursiveLinkAndMergeRows(rowValuesMap);
        return linkedRows.stream().map(values2 -> ResultHandler.getValueData(values2, totalProperties)).collect(Collectors.toList());
    }

    static List<String> getValueData(Map<Integer, String> values2, int totalProperties) {
        return values2.containsKey(-1) ? new ArrayList<String>() : IntStream.range(0, totalProperties).boxed().map(id -> values2.getOrDefault(id, "")).collect(Collectors.toList());
    }

    private static List<Map<Integer, String>> recursiveLinkAndMergeRows(Map<String, Map<Integer, String>> rowValuesMap) {
        Map firstLevelMap = rowValuesMap.entrySet().stream().filter(entry -> !((String)entry.getKey()).contains(LINK_SEPARATOR)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        if (firstLevelMap.isEmpty()) {
            Map rowValuesMapWithoutFirstLinks = rowValuesMap.entrySet().stream().collect(Collectors.toMap(entry -> ResultHandler.removeFirstLinkPart((String)entry.getKey()), Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
            return ResultHandler.recursiveLinkAndMergeRows(rowValuesMapWithoutFirstLinks);
        }
        Map remainingMap = rowValuesMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(LINK_SEPARATOR)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        return remainingMap.isEmpty() ? firstLevelMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList()) : ResultHandler.recursiveLinkAndMergeRows(ResultHandler.linkAndMergeRowMap(firstLevelMap, remainingMap));
    }

    static Map<String, Map<Integer, String>> linkAndMergeRowMap(Map<String, Map<Integer, String>> firstLevelMap, Map<String, Map<Integer, String>> remainingMap) {
        LinkedHashMap<String, Map<Integer, String>> result = new LinkedHashMap<String, Map<Integer, String>>();
        HashSet sharedLinks = new HashSet();
        firstLevelMap.forEach((key, value) -> {
            List shared = remainingMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith((String)key)).collect(Collectors.toList());
            Map remainingMerged = shared.stream().filter(entry -> ((String)entry.getKey()).startsWith((String)key)).collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring(key.length() + LINK_SEPARATOR.length()), entry -> Stream.concat(((Map)entry.getValue()).entrySet().stream(), value.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue)), (oldValue, newValue) -> oldValue, LinkedHashMap::new));
            if (remainingMerged.isEmpty()) {
                result.put((String)key, (Map<Integer, String>)value);
            } else {
                sharedLinks.addAll(shared.stream().map(Map.Entry::getKey).collect(Collectors.toSet()));
                result.putAll(remainingMerged);
            }
        });
        Map remainingMapAfterMerged = remainingMap.entrySet().stream().filter(entry -> !sharedLinks.contains(entry.getKey())).collect(Collectors.toMap(entry -> ResultHandler.removeFirstLinkPart((String)entry.getKey()), Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        if (!remainingMapAfterMerged.isEmpty()) {
            result.putAll(remainingMapAfterMerged);
        }
        return result;
    }

    static String removeFirstLinkPart(String link) {
        if (Utils.isBlank(link)) {
            return link;
        }
        int indexOfLinkSeparator = link.indexOf(LINK_SEPARATOR);
        if (indexOfLinkSeparator == -1) {
            return link;
        }
        return link.substring(indexOfLinkSeparator + LINK_SEPARATOR.length());
    }
}

