/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.xflat.handlers;

import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.sentrysoftware.xflat.Utils;
import org.sentrysoftware.xflat.exceptions.XFlatException;
import org.sentrysoftware.xflat.exceptions.XFlatRunTimeException;
import org.sentrysoftware.xflat.types.SearchPathElement;
import org.sentrysoftware.xflat.types.SearchPathElementAttribute;
import org.sentrysoftware.xflat.types.SearchPathElementProperty;
import org.sentrysoftware.xflat.types.SearchPathNode;

public class SearchPathTreeHandler {
    private static final String ATTRIBUTE_TAG = ">";
    private static final String SLASH = "/";
    private static final String ELEMENT_BEFORE_TAG = "..";

    private SearchPathTreeHandler() {
    }

    public static SearchPathNode build(List<String> propertiesPathList, String rootTag) throws XFlatException {
        Utils.checkNonNull(propertiesPathList, "propertiesPathList");
        Utils.checkNonBlank(rootTag, "rootTag");
        String root = SLASH + rootTag.replaceAll("\\s", "") + SLASH;
        if (propertiesPathList.isEmpty()) {
            throw new XFlatException("Should have at least one property.");
        }
        try {
            List<Deque<SearchPathElement>> searchPathElements = IntStream.range(0, propertiesPathList.size()).mapToObj(i -> SearchPathTreeHandler.buildSearchPathElements(i, (String)propertiesPathList.get(i), root)).sorted((q1, q2) -> q1.stream().map(SearchPathElement::getName).collect(Collectors.joining(SLASH)).compareToIgnoreCase(q2.stream().map(SearchPathElement::getName).collect(Collectors.joining(SLASH)))).collect(Collectors.toList());
            return SearchPathTreeHandler.buildSearchPathNodes(searchPathElements);
        }
        catch (XFlatRunTimeException e) {
            throw new XFlatException(e.getMessage(), e);
        }
    }

    static Deque<SearchPathElement> buildSearchPathElements(int index, String propertyPath, String rootTag) {
        Utils.checkNonBlank(propertyPath, "propertyPath");
        String path = (rootTag + propertyPath).replace("/>", ATTRIBUTE_TAG);
        List pathElements = Stream.of(path.split(SLASH)).filter(Utils::isNotBlank).collect(Collectors.toList());
        Queue rootTags = Stream.of(rootTag.split(SLASH)).filter(Utils::isNotBlank).collect(Collectors.toCollection(LinkedList::new));
        LinkedList<SearchPathElement> pathElementQueue = new LinkedList<SearchPathElement>();
        for (String element : pathElements) {
            String rootTagElement = (String)rootTags.poll();
            if (ELEMENT_BEFORE_TAG.equals(element)) {
                pathElementQueue.removeLast();
                continue;
            }
            SearchPathElement precedent = (SearchPathElement)pathElementQueue.peekLast();
            if (precedent != null && precedent.getName().contains(ATTRIBUTE_TAG)) {
                throw new XFlatRunTimeException(String.format("attribute %s is not the last element of the searchingPath %s", precedent, path));
            }
            pathElementQueue.add(new SearchPathElement(element, rootTagElement != null && element.contains(rootTagElement)));
        }
        SearchPathElement lastElement = (SearchPathElement)pathElementQueue.removeLast();
        if (lastElement.getName().contains(ATTRIBUTE_TAG)) {
            String[] elements = lastElement.getName().split(ATTRIBUTE_TAG);
            if (elements.length != 2) {
                throw new XFlatRunTimeException(String.format("Invalide attribute tag in element %s of the searchingPath %s", lastElement.getName(), path));
            }
            if (!ELEMENT_BEFORE_TAG.equals(elements[0])) {
                pathElementQueue.add(new SearchPathElement(elements[0], lastElement.isFromRootTag()));
            }
            pathElementQueue.add(new SearchPathElementAttribute(index, elements[1]));
        } else {
            pathElementQueue.add(new SearchPathElementProperty(index, lastElement.getName()));
        }
        return pathElementQueue;
    }

    static SearchPathNode buildSearchPathNodes(List<Deque<SearchPathElement>> searchPathElements) {
        SearchPathNode rootTreeNode = null;
        HashMap previousNodeMap = new HashMap();
        int maxQueueSize = searchPathElements.stream().mapToInt(Deque::size).max().orElse(0);
        for (int i = 0; i < maxQueueSize; ++i) {
            HashMap<Integer, SearchPathNode> currentNodeMap = new HashMap<Integer, SearchPathNode>();
            HashMap<SearchPathElement, SearchPathNode> elementsFoundMap = new HashMap<SearchPathElement, SearchPathNode>();
            for (int elementIndex = 0; elementIndex < searchPathElements.size(); ++elementIndex) {
                SearchPathElement element = searchPathElements.get(elementIndex).pollFirst();
                if (element == null) continue;
                SearchPathNode currentNode = elementsFoundMap.computeIfAbsent(element, SearchPathNode::new);
                if (rootTreeNode == null) {
                    rootTreeNode = currentNode;
                }
                currentNodeMap.put(elementIndex, currentNode);
                SearchPathNode previousNode = (SearchPathNode)previousNodeMap.get(elementIndex);
                if (previousNode == null) continue;
                previousNode.addNode(currentNode);
            }
            previousNodeMap.clear();
            previousNodeMap.putAll(currentNodeMap);
        }
        return rootTreeNode;
    }
}

