/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GeneratedMethods;
import org.springframework.beans.factory.aot.ResolvableTypeCodeGenerator;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.core.ResolvableType;
import org.springframework.javapoet.AnnotationSpec;
import org.springframework.javapoet.CodeBlock;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

class BeanDefinitionPropertyValueCodeGenerator {
    static final CodeBlock NULL_VALUE_CODE_BLOCK = CodeBlock.of("null", new Object[0]);
    private final GeneratedMethods generatedMethods;
    private final List<Delegate> delegates;

    BeanDefinitionPropertyValueCodeGenerator(GeneratedMethods generatedMethods, @Nullable BiFunction<Object, ResolvableType, CodeBlock> customValueGenerator) {
        this.generatedMethods = generatedMethods;
        this.delegates = new ArrayList<Delegate>();
        if (customValueGenerator != null) {
            this.delegates.add(customValueGenerator::apply);
        }
        this.delegates.addAll(List.of(new PrimitiveDelegate(), new StringDelegate(), new CharsetDelegate(), new EnumDelegate(), new ClassDelegate(), new ResolvableTypeDelegate(), new ArrayDelegate(), new ManagedListDelegate(), new ManagedSetDelegate(), new ManagedMapDelegate(), new ListDelegate(), new SetDelegate(), new MapDelegate(), new BeanReferenceDelegate()));
    }

    CodeBlock generateCode(@Nullable Object value) {
        ResolvableType type = ResolvableType.forInstance(value);
        try {
            return this.generateCode(value, type);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(BeanDefinitionPropertyValueCodeGenerator.buildErrorMessage(value, type), ex);
        }
    }

    private CodeBlock generateCodeForElement(@Nullable Object value, ResolvableType type) {
        try {
            return this.generateCode(value, type);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(BeanDefinitionPropertyValueCodeGenerator.buildErrorMessage(value, type), ex);
        }
    }

    private static String buildErrorMessage(@Nullable Object value, ResolvableType type) {
        StringBuilder message = new StringBuilder("Failed to generate code for '");
        message.append(value).append("'");
        if (type != ResolvableType.NONE) {
            message.append(" with type ").append(type);
        }
        return message.toString();
    }

    private CodeBlock generateCode(@Nullable Object value, ResolvableType type) {
        if (value == null) {
            return NULL_VALUE_CODE_BLOCK;
        }
        for (Delegate delegate : this.delegates) {
            CodeBlock code = delegate.generateCode(value, type);
            if (code == null) continue;
            return code;
        }
        throw new IllegalArgumentException("Code generation does not support " + type);
    }

    @FunctionalInterface
    private static interface Delegate {
        @Nullable
        public CodeBlock generateCode(Object var1, ResolvableType var2);
    }

    private static class PrimitiveDelegate
    implements Delegate {
        private static final Map<Character, String> CHAR_ESCAPES = Map.of(Character.valueOf('\b'), "\\b", Character.valueOf('\t'), "\\t", Character.valueOf('\n'), "\\n", Character.valueOf('\f'), "\\f", Character.valueOf('\r'), "\\r", Character.valueOf('\"'), "\"", Character.valueOf('\''), "\\'", Character.valueOf('\\'), "\\\\");

        private PrimitiveDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            if (value instanceof Boolean || value instanceof Integer) {
                return CodeBlock.of("$L", value);
            }
            if (value instanceof Byte) {
                return CodeBlock.of("(byte) $L", value);
            }
            if (value instanceof Short) {
                return CodeBlock.of("(short) $L", value);
            }
            if (value instanceof Long) {
                return CodeBlock.of("$LL", value);
            }
            if (value instanceof Float) {
                return CodeBlock.of("$LF", value);
            }
            if (value instanceof Double) {
                return CodeBlock.of("(double) $L", value);
            }
            if (value instanceof Character) {
                Character character = (Character)value;
                return CodeBlock.of("'$L'", this.escape(character.charValue()));
            }
            return null;
        }

        private String escape(char ch) {
            String escaped = CHAR_ESCAPES.get(Character.valueOf(ch));
            if (escaped != null) {
                return escaped;
            }
            return !Character.isISOControl(ch) ? Character.toString(ch) : String.format("\\u%04x", ch);
        }
    }

    private static class StringDelegate
    implements Delegate {
        private StringDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            if (value instanceof String) {
                return CodeBlock.of("$S", value);
            }
            return null;
        }
    }

    private static class CharsetDelegate
    implements Delegate {
        private CharsetDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            if (value instanceof Charset) {
                Charset charset = (Charset)value;
                return CodeBlock.of("$T.forName($S)", Charset.class, charset.name());
            }
            return null;
        }
    }

    private static class EnumDelegate
    implements Delegate {
        private EnumDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            if (value instanceof Enum) {
                Enum enumValue = (Enum)value;
                return CodeBlock.of("$T.$L", enumValue.getDeclaringClass(), enumValue.name());
            }
            return null;
        }
    }

    private static class ClassDelegate
    implements Delegate {
        private ClassDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            if (value instanceof Class) {
                Class clazz = (Class)value;
                return CodeBlock.of("$T.class", ClassUtils.getUserClass(clazz));
            }
            return null;
        }
    }

    private static class ResolvableTypeDelegate
    implements Delegate {
        private ResolvableTypeDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            if (value instanceof ResolvableType) {
                ResolvableType resolvableType = (ResolvableType)value;
                return ResolvableTypeCodeGenerator.generateCode(resolvableType);
            }
            return null;
        }
    }

    private class ArrayDelegate
    implements Delegate {
        private ArrayDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(@Nullable Object value, ResolvableType type) {
            if (type.isArray()) {
                ResolvableType componentType = type.getComponentType();
                Stream<CodeBlock> elements = Arrays.stream(ObjectUtils.toObjectArray(value)).map(component -> BeanDefinitionPropertyValueCodeGenerator.this.generateCode(component, componentType));
                CodeBlock.Builder code = CodeBlock.builder();
                code.add("new $T {", type.toClass());
                code.add(elements.collect(CodeBlock.joining(", ")));
                code.add("}", new Object[0]);
                return code.build();
            }
            return null;
        }
    }

    private class ManagedListDelegate
    extends CollectionDelegate<ManagedList<?>> {
        public ManagedListDelegate() {
            super(ManagedList.class, CodeBlock.of("new $T()", ManagedList.class));
        }
    }

    private class ManagedSetDelegate
    extends CollectionDelegate<ManagedSet<?>> {
        public ManagedSetDelegate() {
            super(ManagedSet.class, CodeBlock.of("new $T()", ManagedSet.class));
        }
    }

    private class ManagedMapDelegate
    implements Delegate {
        private static final CodeBlock EMPTY_RESULT = CodeBlock.of("$T.ofEntries()", ManagedMap.class);

        private ManagedMapDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            if (value instanceof ManagedMap) {
                ManagedMap managedMap = (ManagedMap)value;
                return this.generateManagedMapCode(type, managedMap);
            }
            return null;
        }

        private <K, V> CodeBlock generateManagedMapCode(ResolvableType type, ManagedMap<K, V> managedMap) {
            if (managedMap.isEmpty()) {
                return EMPTY_RESULT;
            }
            ResolvableType keyType = type.as(Map.class).getGeneric(0);
            ResolvableType valueType = type.as(Map.class).getGeneric(1);
            CodeBlock.Builder code = CodeBlock.builder();
            code.add("$T.ofEntries(", ManagedMap.class);
            Iterator iterator2 = managedMap.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                code.add("$T.entry($L,$L)", Map.class, BeanDefinitionPropertyValueCodeGenerator.this.generateCodeForElement(entry.getKey(), keyType), BeanDefinitionPropertyValueCodeGenerator.this.generateCodeForElement(entry.getValue(), valueType));
                if (!iterator2.hasNext()) continue;
                code.add(", ", new Object[0]);
            }
            code.add(")", new Object[0]);
            return code.build();
        }
    }

    private class ListDelegate
    extends CollectionDelegate<List<?>> {
        ListDelegate() {
            super(List.class, CodeBlock.of("$T.emptyList()", Collections.class));
        }
    }

    private class SetDelegate
    extends CollectionDelegate<Set<?>> {
        SetDelegate() {
            super(Set.class, CodeBlock.of("$T.emptySet()", Collections.class));
        }

        @Override
        protected CodeBlock generateCollectionCode(ResolvableType elementType, Set<?> set) {
            if (set instanceof LinkedHashSet) {
                return CodeBlock.of("new $T($L)", LinkedHashSet.class, this.generateCollectionOf(set, List.class, elementType));
            }
            set = this.orderForCodeConsistency(set);
            return super.generateCollectionCode(elementType, set);
        }

        private Set<?> orderForCodeConsistency(Set<?> set) {
            return new TreeSet(set);
        }
    }

    private class MapDelegate
    implements Delegate {
        private static final CodeBlock EMPTY_RESULT = CodeBlock.of("$T.emptyMap()", Collections.class);

        private MapDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            if (value instanceof Map) {
                Map map = (Map)value;
                return this.generateMapCode(type, map);
            }
            return null;
        }

        private <K, V> CodeBlock generateMapCode(ResolvableType type, Map<K, V> map) {
            if (map.isEmpty()) {
                return EMPTY_RESULT;
            }
            ResolvableType keyType = type.as(Map.class).getGeneric(0);
            ResolvableType valueType = type.as(Map.class).getGeneric(1);
            if (map instanceof LinkedHashMap) {
                return this.generateLinkedHashMapCode(map, keyType, valueType);
            }
            boolean useOfEntries = (map = this.orderForCodeConsistency(map)).size() > 10;
            CodeBlock.Builder code = CodeBlock.builder();
            code.add("$T" + (!useOfEntries ? ".of(" : ".ofEntries("), Map.class);
            Iterator<Map.Entry<K, V>> iterator2 = map.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<K, V> entry = iterator2.next();
                CodeBlock keyCode = BeanDefinitionPropertyValueCodeGenerator.this.generateCodeForElement(entry.getKey(), keyType);
                CodeBlock valueCode = BeanDefinitionPropertyValueCodeGenerator.this.generateCodeForElement(entry.getValue(), valueType);
                if (!useOfEntries) {
                    code.add("$L, $L", keyCode, valueCode);
                } else {
                    code.add("$T.entry($L,$L)", Map.class, keyCode, valueCode);
                }
                if (!iterator2.hasNext()) continue;
                code.add(", ", new Object[0]);
            }
            code.add(")", new Object[0]);
            return code.build();
        }

        private <K, V> Map<K, V> orderForCodeConsistency(Map<K, V> map) {
            return new TreeMap<K, V>(map);
        }

        private <K, V> CodeBlock generateLinkedHashMapCode(Map<K, V> map, ResolvableType keyType, ResolvableType valueType) {
            GeneratedMethods generatedMethods = BeanDefinitionPropertyValueCodeGenerator.this.generatedMethods;
            GeneratedMethod generatedMethod = generatedMethods.add("getMap", method -> {
                method.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "{\"rawtypes\", \"unchecked\"}", new Object[0]).build());
                method.returns((Type)((Object)Map.class));
                method.addStatement("$T map = new $T($L)", Map.class, LinkedHashMap.class, map.size());
                map.forEach((key, value) -> method.addStatement("map.put($L, $L)", BeanDefinitionPropertyValueCodeGenerator.this.generateCodeForElement(key, keyType), BeanDefinitionPropertyValueCodeGenerator.this.generateCodeForElement(value, valueType)));
                method.addStatement("return map", new Object[0]);
            });
            return CodeBlock.of("$L()", generatedMethod.getName());
        }
    }

    private static class BeanReferenceDelegate
    implements Delegate {
        private BeanReferenceDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            RuntimeBeanReference runtimeBeanReference;
            if (value instanceof RuntimeBeanReference && (runtimeBeanReference = (RuntimeBeanReference)value).getBeanType() != null) {
                return CodeBlock.of("new $T($T.class)", RuntimeBeanReference.class, runtimeBeanReference.getBeanType());
            }
            if (value instanceof BeanReference) {
                BeanReference beanReference = (BeanReference)value;
                return CodeBlock.of("new $T($S)", RuntimeBeanReference.class, beanReference.getBeanName());
            }
            return null;
        }
    }

    private abstract class CollectionDelegate<T extends Collection<?>>
    implements Delegate {
        private final Class<?> collectionType;
        private final CodeBlock emptyResult;

        public CollectionDelegate(Class<?> collectionType, CodeBlock emptyResult) {
            this.collectionType = collectionType;
            this.emptyResult = emptyResult;
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            if (this.collectionType.isInstance(value)) {
                Collection collection = (Collection)value;
                if (collection.isEmpty()) {
                    return this.emptyResult;
                }
                ResolvableType elementType = type.as(this.collectionType).getGeneric(new int[0]);
                return this.generateCollectionCode(elementType, collection);
            }
            return null;
        }

        protected CodeBlock generateCollectionCode(ResolvableType elementType, T collection) {
            return this.generateCollectionOf((Collection<?>)collection, this.collectionType, elementType);
        }

        protected final CodeBlock generateCollectionOf(Collection<?> collection, Class<?> collectionType, ResolvableType elementType) {
            CodeBlock.Builder code = CodeBlock.builder();
            code.add("$T.of(", collectionType);
            Iterator<?> iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                Object element = iterator2.next();
                code.add("$L", BeanDefinitionPropertyValueCodeGenerator.this.generateCodeForElement(element, elementType));
                if (!iterator2.hasNext()) continue;
                code.add(", ", new Object[0]);
            }
            code.add(")", new Object[0]);
            return code.build();
        }
    }
}

