/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.groovy;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.Writable;
import groovy.xml.StreamingMarkupBuilder;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.groovy.GroovyBeanDefinitionWrapper;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.w3c.dom.Element;

class GroovyDynamicElementReader
extends GroovyObjectSupport {
    private final String rootNamespace;
    private final Map<String, String> xmlNamespaces;
    private final BeanDefinitionParserDelegate delegate;
    private final GroovyBeanDefinitionWrapper beanDefinition;
    protected final boolean decorating;
    private boolean callAfterInvocation = true;

    public GroovyDynamicElementReader(String namespace, Map<String, String> namespaceMap, BeanDefinitionParserDelegate delegate, GroovyBeanDefinitionWrapper beanDefinition, boolean decorating) {
        this.rootNamespace = namespace;
        this.xmlNamespaces = namespaceMap;
        this.delegate = delegate;
        this.beanDefinition = beanDefinition;
        this.decorating = decorating;
    }

    public Object invokeMethod(final String name, Object obj) {
        final Object[] args2 = (Object[])obj;
        if (name.equals("doCall")) {
            Closure callable = (Closure)args2[0];
            callable.setResolveStrategy(1);
            callable.setDelegate((Object)this);
            Object result = callable.call();
            if (this.callAfterInvocation) {
                this.afterInvocation();
                this.callAfterInvocation = false;
            }
            return result;
        }
        final StreamingMarkupBuilder builder = new StreamingMarkupBuilder();
        final String myNamespace = this.rootNamespace;
        final Map<String, String> myNamespaces = this.xmlNamespaces;
        Closure<Object> callable = new Closure<Object>((Object)this){

            public Object call(Object ... arguments) {
                Object object;
                ((GroovyObject)this.getProperty("mkp")).invokeMethod("declareNamespace", (Object)new Object[]{myNamespaces});
                int len = args2.length;
                if (len > 0 && (object = args2[len - 1]) instanceof Closure) {
                    Closure callable = (Closure)object;
                    callable.setResolveStrategy(1);
                    callable.setDelegate((Object)builder);
                }
                return ((GroovyObject)((GroovyObject)this.getDelegate()).getProperty(myNamespace)).invokeMethod(name, (Object)args2);
            }
        };
        callable.setResolveStrategy(1);
        callable.setDelegate((Object)builder);
        Writable writable = (Writable)builder.bind((Object)callable);
        StringWriter sw = new StringWriter();
        try {
            writable.writeTo((Writer)sw);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        Element element = this.delegate.getReaderContext().readDocumentFromString(sw.toString()).getDocumentElement();
        this.delegate.initDefaults(element);
        if (this.decorating) {
            BeanDefinitionHolder holder = this.beanDefinition.getBeanDefinitionHolder();
            holder = this.delegate.decorateIfRequired(element, holder, null);
            this.beanDefinition.setBeanDefinitionHolder(holder);
        } else {
            BeanDefinition beanDefinition = this.delegate.parseCustomElement(element);
            if (beanDefinition != null) {
                this.beanDefinition.setBeanDefinition((AbstractBeanDefinition)beanDefinition);
            }
        }
        if (this.callAfterInvocation) {
            this.afterInvocation();
            this.callAfterInvocation = false;
        }
        return element;
    }

    protected void afterInvocation() {
    }
}

