/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

class DisposableBeanAdapter
implements DisposableBean,
Runnable,
Serializable {
    private static final String DESTROY_METHOD_NAME = "destroy";
    private static final String CLOSE_METHOD_NAME = "close";
    private static final String SHUTDOWN_METHOD_NAME = "shutdown";
    private static final Log logger = LogFactory.getLog(DisposableBeanAdapter.class);
    private final Object bean;
    private final String beanName;
    private final boolean nonPublicAccessAllowed;
    private final boolean invokeDisposableBean;
    private boolean invokeAutoCloseable;
    @Nullable
    private String[] destroyMethodNames;
    @Nullable
    private transient Method[] destroyMethods;
    @Nullable
    private final List<DestructionAwareBeanPostProcessor> beanPostProcessors;

    public DisposableBeanAdapter(Object bean2, String beanName, RootBeanDefinition beanDefinition, List<DestructionAwareBeanPostProcessor> postProcessors) {
        Assert.notNull(bean2, "Disposable bean must not be null");
        this.bean = bean2;
        this.beanName = beanName;
        this.nonPublicAccessAllowed = beanDefinition.isNonPublicAccessAllowed();
        this.invokeDisposableBean = bean2 instanceof DisposableBean && !beanDefinition.hasAnyExternallyManagedDestroyMethod(DESTROY_METHOD_NAME);
        Object[] destroyMethodNames = DisposableBeanAdapter.inferDestroyMethodsIfNecessary(bean2.getClass(), beanDefinition);
        if (!(ObjectUtils.isEmpty(destroyMethodNames) || this.invokeDisposableBean && DESTROY_METHOD_NAME.equals(destroyMethodNames[0]) || beanDefinition.hasAnyExternallyManagedDestroyMethod((String)destroyMethodNames[0]))) {
            boolean bl = this.invokeAutoCloseable = bean2 instanceof AutoCloseable && CLOSE_METHOD_NAME.equals(destroyMethodNames[0]);
            if (!this.invokeAutoCloseable) {
                this.destroyMethodNames = destroyMethodNames;
                Method[] destroyMethods = new Method[destroyMethodNames.length];
                for (int i = 0; i < destroyMethodNames.length; ++i) {
                    Object destroyMethodName = destroyMethodNames[i];
                    Method destroyMethod = this.determineDestroyMethod((String)destroyMethodName);
                    if (destroyMethod == null) {
                        if (beanDefinition.isEnforceDestroyMethod()) {
                            throw new BeanDefinitionValidationException("Could not find a destroy method named '" + (String)destroyMethodName + "' on bean with name '" + beanName + "'");
                        }
                    } else {
                        if (destroyMethod.getParameterCount() > 0) {
                            Class<?>[] paramTypes = destroyMethod.getParameterTypes();
                            if (paramTypes.length > 1) {
                                throw new BeanDefinitionValidationException("Method '" + (String)destroyMethodName + "' of bean '" + beanName + "' has more than one parameter - not supported as destroy method");
                            }
                            if (paramTypes.length == 1 && Boolean.TYPE != paramTypes[0]) {
                                throw new BeanDefinitionValidationException("Method '" + (String)destroyMethodName + "' of bean '" + beanName + "' has a non-boolean parameter - not supported as destroy method");
                            }
                        }
                        destroyMethod = ClassUtils.getInterfaceMethodIfPossible(destroyMethod, bean2.getClass());
                    }
                    destroyMethods[i] = destroyMethod;
                }
                this.destroyMethods = destroyMethods;
            }
        }
        this.beanPostProcessors = DisposableBeanAdapter.filterPostProcessors(postProcessors, bean2);
    }

    public DisposableBeanAdapter(Object bean2, List<DestructionAwareBeanPostProcessor> postProcessors) {
        Assert.notNull(bean2, "Disposable bean must not be null");
        this.bean = bean2;
        this.beanName = bean2.getClass().getName();
        this.nonPublicAccessAllowed = true;
        this.invokeDisposableBean = this.bean instanceof DisposableBean;
        this.beanPostProcessors = DisposableBeanAdapter.filterPostProcessors(postProcessors, bean2);
    }

    private DisposableBeanAdapter(Object bean2, String beanName, boolean nonPublicAccessAllowed, boolean invokeDisposableBean, boolean invokeAutoCloseable, @Nullable String[] destroyMethodNames, @Nullable List<DestructionAwareBeanPostProcessor> postProcessors) {
        this.bean = bean2;
        this.beanName = beanName;
        this.nonPublicAccessAllowed = nonPublicAccessAllowed;
        this.invokeDisposableBean = invokeDisposableBean;
        this.invokeAutoCloseable = invokeAutoCloseable;
        this.destroyMethodNames = destroyMethodNames;
        this.beanPostProcessors = postProcessors;
    }

    @Override
    public void run() {
        this.destroy();
    }

    @Override
    public void destroy() {
        block13: {
            block15: {
                block14: {
                    String msg;
                    if (!CollectionUtils.isEmpty(this.beanPostProcessors)) {
                        for (DestructionAwareBeanPostProcessor processor : this.beanPostProcessors) {
                            processor.postProcessBeforeDestruction(this.bean, this.beanName);
                        }
                    }
                    if (this.invokeDisposableBean) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Invoking destroy() on bean with name '" + this.beanName + "'");
                        }
                        try {
                            ((DisposableBean)this.bean).destroy();
                        }
                        catch (Throwable ex) {
                            msg = "Invocation of destroy method failed on bean with name '" + this.beanName + "'";
                            if (logger.isDebugEnabled()) {
                                logger.warn(msg, ex);
                            }
                            logger.warn(msg + ": " + ex);
                        }
                    }
                    if (!this.invokeAutoCloseable) break block14;
                    if (logger.isTraceEnabled()) {
                        logger.trace("Invoking close() on bean with name '" + this.beanName + "'");
                    }
                    try {
                        ((AutoCloseable)this.bean).close();
                    }
                    catch (Throwable ex) {
                        msg = "Invocation of close method failed on bean with name '" + this.beanName + "'";
                        if (logger.isDebugEnabled()) {
                            logger.warn(msg, ex);
                            break block13;
                        }
                        logger.warn(msg + ": " + ex);
                    }
                    break block13;
                }
                if (this.destroyMethods == null) break block15;
                for (Method destroyMethod : this.destroyMethods) {
                    this.invokeCustomDestroyMethod(destroyMethod);
                }
                break block13;
            }
            if (this.destroyMethodNames == null) break block13;
            for (String destroyMethodName : this.destroyMethodNames) {
                Method destroyMethod = this.determineDestroyMethod(destroyMethodName);
                if (destroyMethod == null) continue;
                this.invokeCustomDestroyMethod(ClassUtils.getInterfaceMethodIfPossible(destroyMethod, this.bean.getClass()));
            }
        }
    }

    @Nullable
    private Method determineDestroyMethod(String name) {
        try {
            return this.findDestroyMethod(name);
        }
        catch (IllegalArgumentException ex) {
            throw new BeanDefinitionValidationException("Could not find unique destroy method on bean with name '" + this.beanName + ": " + ex.getMessage());
        }
    }

    @Nullable
    private Method findDestroyMethod(String name) {
        return this.nonPublicAccessAllowed ? BeanUtils.findMethodWithMinimalParameters(this.bean.getClass(), name) : BeanUtils.findMethodWithMinimalParameters(this.bean.getClass().getMethods(), name);
    }

    private void invokeCustomDestroyMethod(Method destroyMethod) {
        int paramCount = destroyMethod.getParameterCount();
        Object[] args2 = new Object[paramCount];
        if (paramCount == 1) {
            args2[0] = Boolean.TRUE;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Invoking custom destroy method '" + destroyMethod.getName() + "' on bean with name '" + this.beanName + "'");
        }
        try {
            ReflectionUtils.makeAccessible(destroyMethod);
            destroyMethod.invoke(this.bean, args2);
        }
        catch (InvocationTargetException ex) {
            String msg = "Custom destroy method '" + destroyMethod.getName() + "' on bean with name '" + this.beanName + "' threw an exception";
            if (logger.isDebugEnabled()) {
                logger.warn(msg, ex.getTargetException());
            } else {
                logger.warn(msg + ": " + ex.getTargetException());
            }
        }
        catch (Throwable ex) {
            logger.warn("Failed to invoke custom destroy method '" + destroyMethod.getName() + "' on bean with name '" + this.beanName + "'", ex);
        }
    }

    protected Object writeReplace() {
        ArrayList<DestructionAwareBeanPostProcessor> serializablePostProcessors = null;
        if (this.beanPostProcessors != null) {
            serializablePostProcessors = new ArrayList<DestructionAwareBeanPostProcessor>();
            for (DestructionAwareBeanPostProcessor postProcessor : this.beanPostProcessors) {
                if (!(postProcessor instanceof Serializable)) continue;
                serializablePostProcessors.add(postProcessor);
            }
        }
        return new DisposableBeanAdapter(this.bean, this.beanName, this.nonPublicAccessAllowed, this.invokeDisposableBean, this.invokeAutoCloseable, this.destroyMethodNames, serializablePostProcessors);
    }

    public static boolean hasDestroyMethod(Object bean2, RootBeanDefinition beanDefinition) {
        return bean2 instanceof DisposableBean || DisposableBeanAdapter.inferDestroyMethodsIfNecessary(bean2.getClass(), beanDefinition) != null;
    }

    @Nullable
    static String[] inferDestroyMethodsIfNecessary(Class<?> target, RootBeanDefinition beanDefinition) {
        String[] stringArray;
        String[] destroyMethodNames = beanDefinition.getDestroyMethodNames();
        if (destroyMethodNames != null && destroyMethodNames.length > 1) {
            return destroyMethodNames;
        }
        String destroyMethodName = beanDefinition.resolvedDestroyMethodName;
        if (destroyMethodName == null) {
            destroyMethodName = beanDefinition.getDestroyMethodName();
            boolean autoCloseable = AutoCloseable.class.isAssignableFrom(target);
            if ("(inferred)".equals(destroyMethodName) || destroyMethodName == null && autoCloseable) {
                destroyMethodName = null;
                if (!DisposableBean.class.isAssignableFrom(target)) {
                    if (autoCloseable) {
                        destroyMethodName = CLOSE_METHOD_NAME;
                    } else {
                        try {
                            destroyMethodName = target.getMethod(CLOSE_METHOD_NAME, new Class[0]).getName();
                        }
                        catch (NoSuchMethodException ex) {
                            try {
                                destroyMethodName = target.getMethod(SHUTDOWN_METHOD_NAME, new Class[0]).getName();
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            String string = beanDefinition.resolvedDestroyMethodName = destroyMethodName != null ? destroyMethodName : "";
        }
        if (StringUtils.hasLength(destroyMethodName)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = destroyMethodName;
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    public static boolean hasApplicableProcessors(Object bean2, List<DestructionAwareBeanPostProcessor> postProcessors) {
        if (!CollectionUtils.isEmpty(postProcessors)) {
            for (DestructionAwareBeanPostProcessor processor : postProcessors) {
                if (!processor.requiresDestruction(bean2)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static List<DestructionAwareBeanPostProcessor> filterPostProcessors(List<DestructionAwareBeanPostProcessor> processors, Object bean2) {
        ArrayList<DestructionAwareBeanPostProcessor> filteredPostProcessors = null;
        if (!CollectionUtils.isEmpty(processors)) {
            filteredPostProcessors = new ArrayList<DestructionAwareBeanPostProcessor>(processors.size());
            for (DestructionAwareBeanPostProcessor processor : processors) {
                if (!processor.requiresDestruction(bean2)) continue;
                filteredPostProcessors.add(processor);
            }
        }
        return filteredPostProcessors;
    }
}

