/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.lang.reflect.Constructor;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.Aware;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

abstract class ParserStrategyUtils {
    ParserStrategyUtils() {
    }

    static <T> T instantiateClass(Class<?> clazz, Class<T> assignableTo, Environment environment2, ResourceLoader resourceLoader, BeanDefinitionRegistry registry) {
        ClassLoader classLoader;
        Assert.notNull(clazz, "Class must not be null");
        Assert.isAssignable(assignableTo, clazz);
        if (clazz.isInterface()) {
            throw new BeanInstantiationException(clazz, "Specified class is an interface");
        }
        if (registry instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory cbf = (ConfigurableBeanFactory)((Object)registry);
            classLoader = cbf.getBeanClassLoader();
        } else {
            classLoader = resourceLoader.getClassLoader();
        }
        ClassLoader classLoader2 = classLoader;
        Object instance = ParserStrategyUtils.createInstance(clazz, environment2, resourceLoader, registry, classLoader2);
        ParserStrategyUtils.invokeAwareMethods(instance, environment2, resourceLoader, registry, classLoader2);
        return (T)instance;
    }

    private static Object createInstance(Class<?> clazz, Environment environment2, ResourceLoader resourceLoader, BeanDefinitionRegistry registry, @Nullable ClassLoader classLoader) {
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        if (constructors.length == 1 && constructors[0].getParameterCount() > 0) {
            try {
                Constructor<?> constructor = constructors[0];
                Object[] args2 = ParserStrategyUtils.resolveArgs(constructor.getParameterTypes(), environment2, resourceLoader, registry, classLoader);
                return BeanUtils.instantiateClass(constructor, args2);
            }
            catch (Exception ex) {
                throw new BeanInstantiationException(clazz, "No suitable constructor found", (Throwable)ex);
            }
        }
        return BeanUtils.instantiateClass(clazz);
    }

    private static Object[] resolveArgs(Class<?>[] parameterTypes, Environment environment2, ResourceLoader resourceLoader, BeanDefinitionRegistry registry, @Nullable ClassLoader classLoader) {
        Object[] parameters = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameters[i] = ParserStrategyUtils.resolveParameter(parameterTypes[i], environment2, resourceLoader, registry, classLoader);
        }
        return parameters;
    }

    @Nullable
    private static Object resolveParameter(Class<?> parameterType, Environment environment2, ResourceLoader resourceLoader, BeanDefinitionRegistry registry, @Nullable ClassLoader classLoader) {
        if (parameterType == Environment.class) {
            return environment2;
        }
        if (parameterType == ResourceLoader.class) {
            return resourceLoader;
        }
        if (parameterType == BeanFactory.class) {
            return registry instanceof BeanFactory ? registry : null;
        }
        if (parameterType == ClassLoader.class) {
            return classLoader;
        }
        throw new IllegalStateException("Illegal method parameter type: " + parameterType.getName());
    }

    private static void invokeAwareMethods(Object parserStrategyBean, Environment environment2, ResourceLoader resourceLoader, BeanDefinitionRegistry registry, @Nullable ClassLoader classLoader) {
        if (parserStrategyBean instanceof Aware) {
            if (parserStrategyBean instanceof BeanClassLoaderAware) {
                BeanClassLoaderAware beanClassLoaderAware = (BeanClassLoaderAware)parserStrategyBean;
                if (classLoader != null) {
                    beanClassLoaderAware.setBeanClassLoader(classLoader);
                }
            }
            if (parserStrategyBean instanceof BeanFactoryAware) {
                BeanFactoryAware beanFactoryAware = (BeanFactoryAware)parserStrategyBean;
                if (registry instanceof BeanFactory) {
                    BeanFactory beanFactory = (BeanFactory)((Object)registry);
                    beanFactoryAware.setBeanFactory(beanFactory);
                }
            }
            if (parserStrategyBean instanceof EnvironmentAware) {
                EnvironmentAware environmentAware = (EnvironmentAware)parserStrategyBean;
                environmentAware.setEnvironment(environment2);
            }
            if (parserStrategyBean instanceof ResourceLoaderAware) {
                ResourceLoaderAware resourceLoaderAware = (ResourceLoaderAware)parserStrategyBean;
                resourceLoaderAware.setResourceLoader(resourceLoader);
            }
        }
    }
}

