/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.Ordered;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationFilter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.AnnotationsProcessor;
import org.springframework.core.annotation.AttributeMethods;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.lang.Nullable;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

abstract class AnnotationsScanner {
    private static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    private static final Method[] NO_METHODS = new Method[0];
    private static final Map<AnnotatedElement, Annotation[]> declaredAnnotationCache = new ConcurrentReferenceHashMap<AnnotatedElement, Annotation[]>(256);
    private static final Map<Class<?>, Method[]> baseTypeMethodsCache = new ConcurrentReferenceHashMap(256);

    private AnnotationsScanner() {
    }

    @Nullable
    static <C, R> R scan(C context, AnnotatedElement source2, MergedAnnotations.SearchStrategy searchStrategy, Predicate<Class<?>> searchEnclosingClass, AnnotationsProcessor<C, R> processor) {
        R result = AnnotationsScanner.process(context, source2, searchStrategy, searchEnclosingClass, processor);
        return processor.finish(result);
    }

    @Nullable
    private static <C, R> R process(C context, AnnotatedElement source2, MergedAnnotations.SearchStrategy searchStrategy, Predicate<Class<?>> searchEnclosingClass, AnnotationsProcessor<C, R> processor) {
        if (source2 instanceof Class) {
            Class clazz = (Class)source2;
            return AnnotationsScanner.processClass(context, clazz, searchStrategy, searchEnclosingClass, processor);
        }
        if (source2 instanceof Method) {
            Method method = (Method)source2;
            return AnnotationsScanner.processMethod(context, method, searchStrategy, processor);
        }
        return AnnotationsScanner.processElement(context, source2, processor);
    }

    @Nullable
    private static <C, R> R processClass(C context, Class<?> source2, MergedAnnotations.SearchStrategy searchStrategy, Predicate<Class<?>> searchEnclosingClass, AnnotationsProcessor<C, R> processor) {
        return switch (searchStrategy) {
            default -> throw new IncompatibleClassChangeError();
            case MergedAnnotations.SearchStrategy.DIRECT -> AnnotationsScanner.processElement(context, source2, processor);
            case MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS -> AnnotationsScanner.processClassInheritedAnnotations(context, source2, searchStrategy, processor);
            case MergedAnnotations.SearchStrategy.SUPERCLASS -> AnnotationsScanner.processClassHierarchy(context, source2, processor, false, MergedAnnotations.Search.never);
            case MergedAnnotations.SearchStrategy.TYPE_HIERARCHY -> AnnotationsScanner.processClassHierarchy(context, source2, processor, true, searchEnclosingClass);
        };
    }

    @Nullable
    private static <C, R> R processClassInheritedAnnotations(C context, Class<?> source2, MergedAnnotations.SearchStrategy searchStrategy, AnnotationsProcessor<C, R> processor) {
        try {
            if (AnnotationsScanner.isWithoutHierarchy(source2, searchStrategy, MergedAnnotations.Search.never)) {
                return AnnotationsScanner.processElement(context, source2, processor);
            }
            Annotation[] relevant = null;
            int remaining = Integer.MAX_VALUE;
            int aggregateIndex = 0;
            Class<?> root = source2;
            while (source2 != null && source2 != Object.class && remaining > 0 && !AnnotationsScanner.hasPlainJavaAnnotationsOnly(source2)) {
                R result = processor.doWithAggregate(context, aggregateIndex);
                if (result != null) {
                    return result;
                }
                Annotation[] declaredAnnotations = AnnotationsScanner.getDeclaredAnnotations(source2, true);
                if (relevant == null && declaredAnnotations.length > 0) {
                    relevant = root.getAnnotations();
                    remaining = relevant.length;
                }
                for (int i = 0; i < declaredAnnotations.length; ++i) {
                    if (declaredAnnotations[i] == null) continue;
                    boolean isRelevant = false;
                    for (int relevantIndex = 0; relevantIndex < relevant.length; ++relevantIndex) {
                        if (relevant[relevantIndex] == null || declaredAnnotations[i].annotationType() != relevant[relevantIndex].annotationType()) continue;
                        isRelevant = true;
                        relevant[relevantIndex] = null;
                        --remaining;
                        break;
                    }
                    if (isRelevant) continue;
                    declaredAnnotations[i] = null;
                }
                result = processor.doWithAnnotations(context, aggregateIndex, source2, declaredAnnotations);
                if (result != null) {
                    return result;
                }
                source2 = source2.getSuperclass();
                ++aggregateIndex;
            }
        }
        catch (Throwable ex) {
            AnnotationUtils.handleIntrospectionFailure(source2, ex);
        }
        return null;
    }

    @Nullable
    private static <C, R> R processClassHierarchy(C context, Class<?> source2, AnnotationsProcessor<C, R> processor, boolean includeInterfaces, Predicate<Class<?>> searchEnclosingClass) {
        return AnnotationsScanner.processClassHierarchy(context, new int[]{0}, source2, processor, includeInterfaces, searchEnclosingClass);
    }

    @Nullable
    private static <C, R> R processClassHierarchy(C context, int[] aggregateIndex, Class<?> source2, AnnotationsProcessor<C, R> processor, boolean includeInterfaces, Predicate<Class<?>> searchEnclosingClass) {
        block11: {
            try {
                R superclassResult;
                Class<?> superclass;
                R result = processor.doWithAggregate(context, aggregateIndex[0]);
                if (result != null) {
                    return result;
                }
                if (AnnotationsScanner.hasPlainJavaAnnotationsOnly(source2)) {
                    return null;
                }
                Annotation[] annotations = AnnotationsScanner.getDeclaredAnnotations(source2, false);
                result = processor.doWithAnnotations(context, aggregateIndex[0], source2, annotations);
                if (result != null) {
                    return result;
                }
                aggregateIndex[0] = aggregateIndex[0] + 1;
                if (includeInterfaces) {
                    for (Class<?> interfaceType : source2.getInterfaces()) {
                        R interfacesResult = AnnotationsScanner.processClassHierarchy(context, aggregateIndex, interfaceType, processor, true, searchEnclosingClass);
                        if (interfacesResult == null) continue;
                        return interfacesResult;
                    }
                }
                if ((superclass = source2.getSuperclass()) != Object.class && superclass != null && (superclassResult = AnnotationsScanner.processClassHierarchy(context, aggregateIndex, superclass, processor, includeInterfaces, searchEnclosingClass)) != null) {
                    return superclassResult;
                }
                if (!searchEnclosingClass.test(source2)) break block11;
                try {
                    R enclosingResult;
                    Class<?> enclosingClass = source2.getEnclosingClass();
                    if (enclosingClass != null && (enclosingResult = AnnotationsScanner.processClassHierarchy(context, aggregateIndex, enclosingClass, processor, includeInterfaces, searchEnclosingClass)) != null) {
                        return enclosingResult;
                    }
                }
                catch (Throwable ex) {
                    AnnotationUtils.handleIntrospectionFailure(source2, ex);
                }
            }
            catch (Throwable ex) {
                AnnotationUtils.handleIntrospectionFailure(source2, ex);
            }
        }
        return null;
    }

    @Nullable
    private static <C, R> R processMethod(C context, Method source2, MergedAnnotations.SearchStrategy searchStrategy, AnnotationsProcessor<C, R> processor) {
        return switch (searchStrategy) {
            default -> throw new IncompatibleClassChangeError();
            case MergedAnnotations.SearchStrategy.DIRECT, MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS -> AnnotationsScanner.processMethodInheritedAnnotations(context, source2, processor);
            case MergedAnnotations.SearchStrategy.SUPERCLASS -> AnnotationsScanner.processMethodHierarchy(context, new int[]{0}, source2.getDeclaringClass(), processor, source2, false);
            case MergedAnnotations.SearchStrategy.TYPE_HIERARCHY -> AnnotationsScanner.processMethodHierarchy(context, new int[]{0}, source2.getDeclaringClass(), processor, source2, true);
        };
    }

    @Nullable
    private static <C, R> R processMethodInheritedAnnotations(C context, Method source2, AnnotationsProcessor<C, R> processor) {
        try {
            R result = processor.doWithAggregate(context, 0);
            return result != null ? result : AnnotationsScanner.processMethodAnnotations(context, 0, source2, processor);
        }
        catch (Throwable ex) {
            AnnotationUtils.handleIntrospectionFailure(source2, ex);
            return null;
        }
    }

    @Nullable
    private static <C, R> R processMethodHierarchy(C context, int[] aggregateIndex, Class<?> sourceClass, AnnotationsProcessor<C, R> processor, Method rootMethod, boolean includeInterfaces) {
        try {
            R superclassResult;
            Class<?> superclass;
            R result = processor.doWithAggregate(context, aggregateIndex[0]);
            if (result != null) {
                return result;
            }
            if (AnnotationsScanner.hasPlainJavaAnnotationsOnly(sourceClass)) {
                return null;
            }
            boolean calledProcessor = false;
            if (sourceClass == rootMethod.getDeclaringClass()) {
                result = AnnotationsScanner.processMethodAnnotations(context, aggregateIndex[0], rootMethod, processor);
                calledProcessor = true;
                if (result != null) {
                    return result;
                }
            } else {
                for (Method method : AnnotationsScanner.getBaseTypeMethods(context, sourceClass)) {
                    if (method == null || !AnnotationsScanner.isOverride(rootMethod, method)) continue;
                    result = AnnotationsScanner.processMethodAnnotations(context, aggregateIndex[0], method, processor);
                    calledProcessor = true;
                    if (result == null) continue;
                    return result;
                }
            }
            if (Modifier.isPrivate(rootMethod.getModifiers())) {
                return null;
            }
            if (calledProcessor) {
                aggregateIndex[0] = aggregateIndex[0] + 1;
            }
            if (includeInterfaces) {
                for (GenericDeclaration genericDeclaration : sourceClass.getInterfaces()) {
                    R interfacesResult = AnnotationsScanner.processMethodHierarchy(context, aggregateIndex, genericDeclaration, processor, rootMethod, true);
                    if (interfacesResult == null) continue;
                    return interfacesResult;
                }
            }
            if ((superclass = sourceClass.getSuperclass()) != Object.class && superclass != null && (superclassResult = AnnotationsScanner.processMethodHierarchy(context, aggregateIndex, superclass, processor, rootMethod, includeInterfaces)) != null) {
                return superclassResult;
            }
        }
        catch (Throwable ex) {
            AnnotationUtils.handleIntrospectionFailure(rootMethod, ex);
        }
        return null;
    }

    private static <C> Method[] getBaseTypeMethods(C context, Class<?> baseType) {
        if (baseType == Object.class || AnnotationsScanner.hasPlainJavaAnnotationsOnly(baseType)) {
            return NO_METHODS;
        }
        Method[] methods = baseTypeMethodsCache.get(baseType);
        if (methods == null) {
            boolean isInterface = baseType.isInterface();
            methods = isInterface ? baseType.getMethods() : ReflectionUtils.getDeclaredMethods(baseType);
            int cleared = 0;
            for (int i = 0; i < methods.length; ++i) {
                if ((isInterface || !Modifier.isPrivate(methods[i].getModifiers())) && !AnnotationsScanner.hasPlainJavaAnnotationsOnly(methods[i]) && AnnotationsScanner.getDeclaredAnnotations(methods[i], false).length != 0) continue;
                methods[i] = null;
                ++cleared;
            }
            if (cleared == methods.length) {
                methods = NO_METHODS;
            }
            baseTypeMethodsCache.put(baseType, methods);
        }
        return methods;
    }

    private static boolean isOverride(Method rootMethod, Method candidateMethod) {
        return !Modifier.isPrivate(candidateMethod.getModifiers()) && candidateMethod.getName().equals(rootMethod.getName()) && AnnotationsScanner.hasSameParameterTypes(rootMethod, candidateMethod);
    }

    private static boolean hasSameParameterTypes(Method rootMethod, Method candidateMethod) {
        if (candidateMethod.getParameterCount() != rootMethod.getParameterCount()) {
            return false;
        }
        Object[] rootParameterTypes = rootMethod.getParameterTypes();
        Object[] candidateParameterTypes = candidateMethod.getParameterTypes();
        if (Arrays.equals(candidateParameterTypes, rootParameterTypes)) {
            return true;
        }
        return AnnotationsScanner.hasSameGenericTypeParameters(rootMethod, candidateMethod, rootParameterTypes);
    }

    private static boolean hasSameGenericTypeParameters(Method rootMethod, Method candidateMethod, Class<?>[] rootParameterTypes) {
        Class<?> sourceDeclaringClass = rootMethod.getDeclaringClass();
        Class<?> candidateDeclaringClass = candidateMethod.getDeclaringClass();
        if (!candidateDeclaringClass.isAssignableFrom(sourceDeclaringClass)) {
            return false;
        }
        for (int i = 0; i < rootParameterTypes.length; ++i) {
            Class<?> resolvedParameterType = ResolvableType.forMethodParameter(candidateMethod, i, sourceDeclaringClass).resolve();
            if (rootParameterTypes[i] == resolvedParameterType) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static <C, R> R processMethodAnnotations(C context, int aggregateIndex, Method source2, AnnotationsProcessor<C, R> processor) {
        Object[] annotations = AnnotationsScanner.getDeclaredAnnotations(source2, false);
        R result = processor.doWithAnnotations(context, aggregateIndex, source2, (Annotation[])annotations);
        if (result != null) {
            return result;
        }
        Method bridgedMethod = BridgeMethodResolver.findBridgedMethod(source2);
        if (bridgedMethod != source2) {
            Annotation[] bridgedAnnotations = AnnotationsScanner.getDeclaredAnnotations(bridgedMethod, true);
            for (int i = 0; i < bridgedAnnotations.length; ++i) {
                if (!ObjectUtils.containsElement(annotations, bridgedAnnotations[i])) continue;
                bridgedAnnotations[i] = null;
            }
            return processor.doWithAnnotations(context, aggregateIndex, source2, bridgedAnnotations);
        }
        return null;
    }

    @Nullable
    private static <C, R> R processElement(C context, AnnotatedElement source2, AnnotationsProcessor<C, R> processor) {
        try {
            R result = processor.doWithAggregate(context, 0);
            return result != null ? result : processor.doWithAnnotations(context, 0, source2, AnnotationsScanner.getDeclaredAnnotations(source2, false));
        }
        catch (Throwable ex) {
            AnnotationUtils.handleIntrospectionFailure(source2, ex);
            return null;
        }
    }

    @Nullable
    static <A extends Annotation> A getDeclaredAnnotation(AnnotatedElement source2, Class<A> annotationType) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = AnnotationsScanner.getDeclaredAnnotations(source2, false)) {
            if (annotation == null || annotationType != annotation.annotationType()) continue;
            return (A)annotation;
        }
        return null;
    }

    static Annotation[] getDeclaredAnnotations(AnnotatedElement source2, boolean defensive) {
        boolean cached = false;
        Annotation[] annotations = declaredAnnotationCache.get(source2);
        if (annotations != null) {
            cached = true;
        } else {
            annotations = source2.getDeclaredAnnotations();
            if (annotations.length != 0) {
                boolean allIgnored = true;
                for (int i = 0; i < annotations.length; ++i) {
                    Annotation annotation = annotations[i];
                    if (AnnotationsScanner.isIgnorable(annotation.annotationType()) || !AttributeMethods.forAnnotationType(annotation.annotationType()).isValid(annotation)) {
                        annotations[i] = null;
                        continue;
                    }
                    allIgnored = false;
                }
                Annotation[] annotationArray = annotations = allIgnored ? NO_ANNOTATIONS : annotations;
                if (source2 instanceof Class || source2 instanceof Member) {
                    declaredAnnotationCache.put(source2, annotations);
                    cached = true;
                }
            }
        }
        if (!defensive || annotations.length == 0 || !cached) {
            return annotations;
        }
        return (Annotation[])annotations.clone();
    }

    private static boolean isIgnorable(Class<?> annotationType) {
        return AnnotationFilter.PLAIN.matches(annotationType);
    }

    static boolean isKnownEmpty(AnnotatedElement source2, MergedAnnotations.SearchStrategy searchStrategy, Predicate<Class<?>> searchEnclosingClass) {
        if (AnnotationsScanner.hasPlainJavaAnnotationsOnly(source2)) {
            return true;
        }
        if (searchStrategy == MergedAnnotations.SearchStrategy.DIRECT || AnnotationsScanner.isWithoutHierarchy(source2, searchStrategy, searchEnclosingClass)) {
            Method method;
            if (source2 instanceof Method && (method = (Method)source2).isBridge()) {
                return false;
            }
            return AnnotationsScanner.getDeclaredAnnotations(source2, false).length == 0;
        }
        return false;
    }

    static boolean hasPlainJavaAnnotationsOnly(@Nullable Object annotatedElement) {
        if (annotatedElement instanceof Class) {
            Class clazz = (Class)annotatedElement;
            return AnnotationsScanner.hasPlainJavaAnnotationsOnly(clazz);
        }
        if (annotatedElement instanceof Member) {
            Member member = (Member)annotatedElement;
            return AnnotationsScanner.hasPlainJavaAnnotationsOnly(member.getDeclaringClass());
        }
        return false;
    }

    static boolean hasPlainJavaAnnotationsOnly(Class<?> type) {
        return type.getName().startsWith("java.") || type == Ordered.class;
    }

    private static boolean isWithoutHierarchy(AnnotatedElement source2, MergedAnnotations.SearchStrategy searchStrategy, Predicate<Class<?>> searchEnclosingClass) {
        if (source2 == Object.class) {
            return true;
        }
        if (source2 instanceof Class) {
            boolean noSuperTypes;
            Class sourceClass = (Class)source2;
            boolean bl = noSuperTypes = sourceClass.getSuperclass() == Object.class && sourceClass.getInterfaces().length == 0;
            return searchEnclosingClass.test(sourceClass) ? noSuperTypes && sourceClass.getEnclosingClass() == null : noSuperTypes;
        }
        if (source2 instanceof Method) {
            Method sourceMethod = (Method)source2;
            return Modifier.isPrivate(sourceMethod.getModifiers()) || AnnotationsScanner.isWithoutHierarchy(sourceMethod.getDeclaringClass(), searchStrategy, searchEnclosingClass);
        }
        return true;
    }

    static void clearCache() {
        declaredAnnotationCache.clear();
        baseTypeMethodsCache.clear();
    }
}

