/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.springframework.core.annotation.AnnotationFilter;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotationSelector;
import org.springframework.core.annotation.MergedAnnotationsCollection;
import org.springframework.core.annotation.RepeatableContainers;
import org.springframework.core.annotation.TypeMappedAnnotations;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface MergedAnnotations
extends Iterable<MergedAnnotation<Annotation>> {
    public <A extends Annotation> boolean isPresent(Class<A> var1);

    public boolean isPresent(String var1);

    public <A extends Annotation> boolean isDirectlyPresent(Class<A> var1);

    public boolean isDirectlyPresent(String var1);

    public <A extends Annotation> MergedAnnotation<A> get(Class<A> var1);

    public <A extends Annotation> MergedAnnotation<A> get(Class<A> var1, @Nullable Predicate<? super MergedAnnotation<A>> var2);

    public <A extends Annotation> MergedAnnotation<A> get(Class<A> var1, @Nullable Predicate<? super MergedAnnotation<A>> var2, @Nullable MergedAnnotationSelector<A> var3);

    public <A extends Annotation> MergedAnnotation<A> get(String var1);

    public <A extends Annotation> MergedAnnotation<A> get(String var1, @Nullable Predicate<? super MergedAnnotation<A>> var2);

    public <A extends Annotation> MergedAnnotation<A> get(String var1, @Nullable Predicate<? super MergedAnnotation<A>> var2, @Nullable MergedAnnotationSelector<A> var3);

    public <A extends Annotation> Stream<MergedAnnotation<A>> stream(Class<A> var1);

    public <A extends Annotation> Stream<MergedAnnotation<A>> stream(String var1);

    public Stream<MergedAnnotation<Annotation>> stream();

    public static MergedAnnotations from(AnnotatedElement element) {
        return MergedAnnotations.from(element, SearchStrategy.DIRECT);
    }

    public static MergedAnnotations from(AnnotatedElement element, SearchStrategy searchStrategy) {
        return MergedAnnotations.from(element, searchStrategy, RepeatableContainers.standardRepeatables());
    }

    public static MergedAnnotations from(AnnotatedElement element, SearchStrategy searchStrategy, RepeatableContainers repeatableContainers) {
        return MergedAnnotations.from(element, searchStrategy, repeatableContainers, AnnotationFilter.PLAIN);
    }

    public static MergedAnnotations from(AnnotatedElement element, SearchStrategy searchStrategy, RepeatableContainers repeatableContainers, AnnotationFilter annotationFilter) {
        return MergedAnnotations.from(element, searchStrategy, Search.never, repeatableContainers, annotationFilter);
    }

    private static MergedAnnotations from(AnnotatedElement element, SearchStrategy searchStrategy, Predicate<Class<?>> searchEnclosingClass, RepeatableContainers repeatableContainers, AnnotationFilter annotationFilter) {
        Assert.notNull((Object)element, "AnnotatedElement must not be null");
        Assert.notNull((Object)searchStrategy, "SearchStrategy must not be null");
        Assert.notNull(searchEnclosingClass, "Predicate must not be null");
        Assert.notNull((Object)repeatableContainers, "RepeatableContainers must not be null");
        Assert.notNull((Object)annotationFilter, "AnnotationFilter must not be null");
        return TypeMappedAnnotations.from(element, searchStrategy, searchEnclosingClass, repeatableContainers, annotationFilter);
    }

    public static MergedAnnotations from(Annotation ... annotations) {
        return MergedAnnotations.from((Object)annotations, annotations);
    }

    public static MergedAnnotations from(Object source2, Annotation ... annotations) {
        return MergedAnnotations.from(source2, annotations, RepeatableContainers.standardRepeatables());
    }

    public static MergedAnnotations from(Object source2, Annotation[] annotations, RepeatableContainers repeatableContainers) {
        return MergedAnnotations.from(source2, annotations, repeatableContainers, AnnotationFilter.PLAIN);
    }

    public static MergedAnnotations from(Object source2, Annotation[] annotations, RepeatableContainers repeatableContainers, AnnotationFilter annotationFilter) {
        Assert.notNull((Object)repeatableContainers, "RepeatableContainers must not be null");
        Assert.notNull((Object)annotationFilter, "AnnotationFilter must not be null");
        return TypeMappedAnnotations.from(source2, annotations, repeatableContainers, annotationFilter);
    }

    public static MergedAnnotations of(Collection<MergedAnnotation<?>> annotations) {
        return MergedAnnotationsCollection.of(annotations);
    }

    public static Search search(SearchStrategy searchStrategy) {
        Assert.notNull((Object)searchStrategy, "SearchStrategy must not be null");
        return new Search(searchStrategy);
    }

    public static enum SearchStrategy {
        DIRECT,
        INHERITED_ANNOTATIONS,
        SUPERCLASS,
        TYPE_HIERARCHY;

    }

    public static final class Search {
        static final Predicate<Class<?>> always = clazz -> true;
        static final Predicate<Class<?>> never = clazz -> false;
        private final SearchStrategy searchStrategy;
        private Predicate<Class<?>> searchEnclosingClass = never;
        private RepeatableContainers repeatableContainers = RepeatableContainers.standardRepeatables();
        private AnnotationFilter annotationFilter = AnnotationFilter.PLAIN;

        private Search(SearchStrategy searchStrategy) {
            this.searchStrategy = searchStrategy;
        }

        public Search withEnclosingClasses(Predicate<Class<?>> searchEnclosingClass) {
            Assert.notNull(searchEnclosingClass, "Predicate must not be null");
            Assert.state(this.searchStrategy == SearchStrategy.TYPE_HIERARCHY, "A custom 'searchEnclosingClass' predicate can only be combined with SearchStrategy.TYPE_HIERARCHY");
            this.searchEnclosingClass = searchEnclosingClass;
            return this;
        }

        public Search withRepeatableContainers(RepeatableContainers repeatableContainers) {
            Assert.notNull((Object)repeatableContainers, "RepeatableContainers must not be null");
            this.repeatableContainers = repeatableContainers;
            return this;
        }

        public Search withAnnotationFilter(AnnotationFilter annotationFilter) {
            Assert.notNull((Object)annotationFilter, "AnnotationFilter must not be null");
            this.annotationFilter = annotationFilter;
            return this;
        }

        public MergedAnnotations from(AnnotatedElement element) {
            return MergedAnnotations.from(element, this.searchStrategy, this.searchEnclosingClass, this.repeatableContainers, this.annotationFilter);
        }
    }
}

