/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.vcenter;

import com.vmware.vim25.HostServiceTicket;
import com.vmware.vim25.InvalidLogin;
import com.vmware.vim25.mo.Datacenter;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ServiceInstance;
import java.net.InetAddress;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class VCenterClient {
    private static final String ENTITY_HOST_SYSTEM = "HostSystem";
    private static final String ENTITY_DATA_CENTER = "Datacenter";
    private static Supplier<Boolean> isDebugEnabled;
    private static Consumer<String> debug;

    public static void setDebug(Supplier<Boolean> isDebugEnabledMethod, Consumer<String> debugMethod) {
        isDebugEnabled = isDebugEnabledMethod;
        debug = debugMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String requestCertificate(String vCenterName, String username, String password, String hostname) throws InvalidLogin, Exception {
        ServiceInstance serviceInstance = null;
        try {
            URL vCenterURL = new URL("https://" + vCenterName + "/sdk");
            debug.accept("Connecting to " + vCenterURL.toString() + "...");
            serviceInstance = new ServiceInstance(vCenterURL, username, password, true);
            HostSystem hostSystem = VCenterClient.getHostSystemManagedEntity(serviceInstance, hostname);
            if (hostSystem == null) {
                throw new Exception("Unable to find host " + hostname + " in VCenter " + vCenterName);
            }
            HostServiceTicket ticket = hostSystem.acquireCimServicesTicket();
            String string = ticket.getSessionId();
            return string;
        }
        finally {
            if (serviceInstance != null) {
                serviceInstance.getServerConnection().logout();
            }
        }
    }

    private static HostSystem getHostSystemManagedEntity(ServiceInstance serviceInstance, String systemName) throws Exception {
        InetAddress[] hostIPaddresses;
        Folder rootFolder = serviceInstance.getRootFolder();
        if (rootFolder == null) {
            throw new Exception("Couldn't get the root folder");
        }
        InventoryNavigator inventoryNavigator = new InventoryNavigator((ManagedEntity)rootFolder);
        ManagedEntity[] managedEntities = inventoryNavigator.searchManagedEntities(ENTITY_HOST_SYSTEM);
        if (managedEntities != null) {
            String entityName;
            for (ManagedEntity managedEntity : managedEntities) {
                entityName = managedEntity.getName();
                if (!systemName.equalsIgnoreCase(entityName)) continue;
                return (HostSystem)managedEntity;
            }
            if (systemName.indexOf(46) == -1) {
                for (ManagedEntity managedEntity : managedEntities) {
                    String shortEntityName;
                    entityName = managedEntity.getName();
                    int dotIndex = entityName.indexOf(46);
                    if (dotIndex <= 1 || !systemName.equalsIgnoreCase(shortEntityName = entityName.substring(0, dotIndex))) continue;
                    return (HostSystem)managedEntity;
                }
            }
            if (isDebugEnabled.get().booleanValue()) {
                String managedEntitiesString = "";
                for (ManagedEntity managedEntity : managedEntities) {
                    managedEntitiesString = managedEntitiesString + " - " + managedEntity.getName() + "\n";
                }
                StringBuilder entityList = new StringBuilder();
                for (ManagedEntity managedEntity : managedEntities) {
                    entityList.append(" - ").append(managedEntity.getName()).append("\n");
                }
                debug.accept("VCenterClient: Couldn't find host " + systemName + " in the list of managed entities in VCenter " + serviceInstance.getServerConnection().getUrl().getHost() + ":\n" + entityList);
                debug.accept("VCenterClient: Will now try with the IP address of " + systemName);
            }
        }
        if (null == (managedEntities = inventoryNavigator.searchManagedEntities(ENTITY_DATA_CENTER)) || managedEntities.length == 0) {
            throw new Exception("No Datacenter-type managed entity");
        }
        try {
            hostIPaddresses = InetAddress.getAllByName(systemName);
        }
        catch (Exception e) {
            throw new Exception("Couldn't resolve " + systemName + " into a valid IP address");
        }
        for (ManagedEntity datacenterEntity : managedEntities) {
            for (InetAddress hostIPaddress : hostIPaddresses) {
                ManagedEntity[] managedEntitiesInDatacenter = serviceInstance.getSearchIndex().findAllByIp((Datacenter)datacenterEntity, hostIPaddress.getHostAddress(), false);
                if (managedEntitiesInDatacenter == null || managedEntitiesInDatacenter.length == 0) continue;
                return (HostSystem)managedEntitiesInDatacenter[0];
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getAllHostSystemManagedEntities(String vCenterName, String username, String password) throws Exception {
        ServiceInstance serviceInstance = null;
        try {
            URL vCenterURL = new URL("https://" + vCenterName + "/sdk");
            debug.accept("Connecting to " + vCenterURL.toString() + "...");
            serviceInstance = new ServiceInstance(vCenterURL, username, password, true);
            Folder rootFolder = serviceInstance.getRootFolder();
            if (rootFolder == null) {
                throw new Exception("Couldn't get the root folder");
            }
            InventoryNavigator inventoryNavigator = new InventoryNavigator((ManagedEntity)rootFolder);
            List<String> list = Arrays.stream(inventoryNavigator.searchManagedEntities(ENTITY_HOST_SYSTEM)).map(ManagedEntity::getName).collect(Collectors.toList());
            return list;
        }
        finally {
            if (serviceInstance != null) {
                serviceInstance.getServerConnection().logout();
            }
        }
    }
}

