/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.winrm.service.client.auth.ntlm;

import org.apache.commons.codec.binary.Base64;
import org.apache.http.impl.auth.NTLMEngineException;
import org.sentrysoftware.winrm.service.client.auth.ntlm.NTLMEngineUtils;

class NTLMMessage {
    private static final byte[] SIGNATURE;
    protected byte[] messageContents = null;
    protected int currentOutputPosition = 0;

    NTLMMessage() {
    }

    NTLMMessage(byte[] message, int expectedType) throws NTLMEngineException {
        this.messageContents = message;
        if (this.messageContents.length < SIGNATURE.length) {
            throw new NTLMEngineException("NTLM message decoding error - packet too short");
        }
        for (int i = 0; i < SIGNATURE.length; ++i) {
            if (this.messageContents[i] == SIGNATURE[i]) continue;
            throw new NTLMEngineException("NTLM message expected - instead got unrecognized bytes");
        }
        int type = this.readULong(SIGNATURE.length);
        if (type != expectedType) {
            throw new NTLMEngineException(String.format("NTLM type %d message expected - instead got type %d", expectedType, type));
        }
        this.currentOutputPosition = this.messageContents.length;
    }

    int readULong(int position) {
        return NTLMMessage.readULong(this.messageContents, position);
    }

    static int readULong(byte[] src, int index) {
        if (src.length < index + 4) {
            return 0;
        }
        return src[index] & 0xFF | (src[index + 1] & 0xFF) << 8 | (src[index + 2] & 0xFF) << 16 | (src[index + 3] & 0xFF) << 24;
    }

    void prepareResponse(int maxlength, int messageType) {
        this.messageContents = new byte[maxlength];
        this.currentOutputPosition = 0;
        this.addBytes(SIGNATURE);
        this.addULong(messageType);
    }

    private void addByte(byte b) {
        this.messageContents[this.currentOutputPosition] = b;
        ++this.currentOutputPosition;
    }

    void addBytes(byte[] bytes) {
        if (bytes == null) {
            return;
        }
        byte[] byArray = bytes;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte b;
            this.messageContents[this.currentOutputPosition] = b = byArray[i];
            ++this.currentOutputPosition;
        }
    }

    void addUShort(int value) {
        this.addByte((byte)(value & 0xFF));
        this.addByte((byte)(value >> 8 & 0xFF));
    }

    void addULong(int value) {
        this.addByte((byte)(value & 0xFF));
        this.addByte((byte)(value >> 8 & 0xFF));
        this.addByte((byte)(value >> 16 & 0xFF));
        this.addByte((byte)(value >> 24 & 0xFF));
    }

    String getResponse() {
        return new String(Base64.encodeBase64((byte[])this.getBytes()), NTLMEngineUtils.DEFAULT_CHARSET);
    }

    private byte[] getBytes() {
        if (this.messageContents == null) {
            this.buildMessage();
        }
        if (this.messageContents.length > this.currentOutputPosition) {
            byte[] tmp = new byte[this.currentOutputPosition];
            System.arraycopy(this.messageContents, 0, tmp, 0, this.currentOutputPosition);
            this.messageContents = tmp;
        }
        return this.messageContents;
    }

    protected void buildMessage() {
        throw new RuntimeException("Message builder not implemented for " + this.getClass().getName());
    }

    static {
        byte[] bytesWithoutNull = "NTLMSSP".getBytes(NTLMEngineUtils.DEFAULT_CHARSET);
        byte[] target = new byte[bytesWithoutNull.length + 1];
        System.arraycopy(bytesWithoutNull, 0, target, 0, bytesWithoutNull.length);
        target[bytesWithoutNull.length] = 0;
        SIGNATURE = target;
    }
}

