/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.winrm.service.client.auth.ntlm;

import java.util.function.LongUnaryOperator;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.message.BasicHeader;
import org.sentrysoftware.winrm.service.client.auth.ntlm.NTLMEngine;
import org.sentrysoftware.winrm.service.client.auth.ntlm.NTLMEngineImpl;
import org.sentrysoftware.winrm.service.client.auth.ntlm.NTLMScheme;
import org.sentrysoftware.winrm.service.client.auth.ntlm.Type1Message;

public class NtlmMasqAsSpnegoScheme
extends NTLMScheme {
    private static final LongUnaryOperator FLAG_MODIFIER = flags -> flags | 0x10L | 0x20L | 0x40000000L;

    public NtlmMasqAsSpnegoScheme() {
        super(NtlmMasqAsSpnegoScheme.newDefaultNtlmEngine());
    }

    private static NTLMEngine newDefaultNtlmEngine() {
        return new NTLMEngineImpl(){

            @Override
            public Integer getDefaultFlags() {
                Long flags = Type1Message.getDefaultFlags();
                return (int)FLAG_MODIFIER.applyAsLong(flags);
            }
        };
    }

    @Override
    public String getSchemeName() {
        return "Negotiate";
    }

    @Override
    public Header authenticate(Credentials credentials, HttpRequest httpRequest) throws AuthenticationException {
        Header header = super.authenticate(credentials, httpRequest);
        return new BasicHeader(header.getName(), header.getValue().replace("NTLM", this.getSchemeName()));
    }
}

