/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.winrm.service.client.auth.ntlm;

import org.apache.commons.codec.binary.Base64;
import org.apache.http.impl.auth.NTLMEngineException;
import org.sentrysoftware.winrm.service.client.auth.ntlm.NTLMEngineUtils;
import org.sentrysoftware.winrm.service.client.auth.ntlm.NTLMMessage;

class Type2Message
extends NTLMMessage {
    private final byte[] challenge = new byte[8];
    private String target;
    private byte[] targetInfo;
    private final int flags;

    Type2Message(String messageBody) throws NTLMEngineException {
        this(Base64.decodeBase64((byte[])messageBody.getBytes(NTLMEngineUtils.DEFAULT_CHARSET)));
    }

    private Type2Message(byte[] message) throws NTLMEngineException {
        super(message, 2);
        byte[] bytes;
        this.readBytes(this.challenge, 24);
        this.flags = this.readULong(20);
        this.target = null;
        if (this.getMessageLength() >= 20 && (bytes = this.readSecurityBuffer(12)).length != 0) {
            this.target = new String(bytes, NTLMEngineUtils.getCharset(this.flags));
        }
        this.targetInfo = null;
        if (this.getMessageLength() >= 48 && (bytes = this.readSecurityBuffer(40)).length != 0) {
            this.targetInfo = bytes;
        }
    }

    private int getMessageLength() {
        return this.currentOutputPosition;
    }

    private void readBytes(byte[] buffer, int position) throws NTLMEngineException {
        if (this.messageContents.length < position + buffer.length) {
            throw new NTLMEngineException("NTLM: Message too short");
        }
        System.arraycopy(this.messageContents, position, buffer, 0, buffer.length);
    }

    private byte[] readSecurityBuffer(int position) {
        int length = Type2Message.readUShort(this.messageContents, position);
        int offset = Type2Message.readULong(this.messageContents, position + 4);
        if (this.messageContents.length < offset + length) {
            return new byte[length];
        }
        byte[] buffer = new byte[length];
        System.arraycopy(this.messageContents, offset, buffer, 0, length);
        return buffer;
    }

    private static int readUShort(byte[] src, int index) {
        if (src.length < index + 2) {
            return 0;
        }
        return src[index] & 0xFF | (src[index + 1] & 0xFF) << 8;
    }

    byte[] getChallenge() {
        return this.challenge;
    }

    String getTarget() {
        return this.target;
    }

    byte[] getTargetInfo() {
        return this.targetInfo;
    }

    int getFlags() {
        return this.flags;
    }
}

