/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.winrm.service.client.auth.ntlm;

import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Locale;
import org.apache.http.impl.auth.NTLMEngineException;
import org.sentrysoftware.winrm.service.client.auth.ntlm.NTLMEngineImpl;
import org.sentrysoftware.winrm.service.client.auth.ntlm.NTLMEngineUtils;
import org.sentrysoftware.winrm.service.client.auth.ntlm.NTLMMessage;
import org.sentrysoftware.winrm.service.client.encryption.CipherGen;
import org.sentrysoftware.winrm.service.client.encryption.EncryptionUtils;

public class Type3Message
extends NTLMMessage {
    static final SecureRandom RND_GEN;
    private final int type2Flags;
    private final byte[] domainBytes;
    private final byte[] hostBytes;
    private final byte[] userBytes;
    private byte[] lmResp;
    private byte[] ntResp;
    private final byte[] sessionKey;
    private final byte[] exportedSessionKey;

    Type3Message(String domain, String host, String user, String password, byte[] nonce, int type2Flags, String target, byte[] targetInformation) throws NTLMEngineException {
        byte[] userSessionKey;
        SecureRandom random = RND_GEN;
        if (random == null) {
            throw new NTLMEngineException("Random generator not available");
        }
        long currentTime = System.currentTimeMillis();
        this.type2Flags = type2Flags;
        String unqualifiedHost = NTLMEngineImpl.convertHost(host);
        String unqualifiedDomain = NTLMEngineImpl.convertDomain(domain);
        byte[] responseTargetInformation = targetInformation;
        CipherGen gen = new CipherGen(random, currentTime, unqualifiedDomain, user, password, nonce, target, responseTargetInformation);
        try {
            if ((type2Flags & 0x800000) != 0 && targetInformation != null && target != null) {
                this.ntResp = gen.getNTLMv2Response();
                this.lmResp = gen.getLMv2Response();
                userSessionKey = (type2Flags & 0x80) != 0 ? gen.getLanManagerSessionKey() : gen.getNTLMv2UserSessionKey();
            } else if ((type2Flags & 0x80000) != 0) {
                this.ntResp = gen.getNTLM2SessionResponse();
                this.lmResp = gen.getLM2SessionResponse();
                userSessionKey = (type2Flags & 0x80) != 0 ? gen.getLanManagerSessionKey() : gen.getNTLM2SessionResponseUserSessionKey();
            } else {
                this.ntResp = gen.getNTLMResponse();
                this.lmResp = gen.getLMResponse();
                userSessionKey = (type2Flags & 0x80) != 0 ? gen.getLanManagerSessionKey() : gen.getNTLMUserSessionKey();
            }
        }
        catch (NTLMEngineException e) {
            this.ntResp = new byte[0];
            this.lmResp = gen.getLMResponse();
            userSessionKey = (type2Flags & 0x80) != 0 ? gen.getLanManagerSessionKey() : gen.getLMUserSessionKey();
        }
        if ((type2Flags & 0x10) != 0) {
            if ((type2Flags & 0x40000000) != 0) {
                this.exportedSessionKey = gen.getSecondaryKey();
                try {
                    this.sessionKey = EncryptionUtils.calculateRC4(this.exportedSessionKey, userSessionKey);
                }
                catch (Exception e) {
                    throw new NTLMEngineException(e.getMessage(), (Throwable)e);
                }
            } else {
                this.sessionKey = userSessionKey;
                this.exportedSessionKey = this.sessionKey;
            }
        } else {
            this.sessionKey = null;
            this.exportedSessionKey = null;
        }
        Charset charset = NTLMEngineUtils.getCharset(type2Flags);
        this.hostBytes = unqualifiedHost != null ? unqualifiedHost.getBytes(charset) : null;
        this.domainBytes = unqualifiedDomain != null ? unqualifiedDomain.toUpperCase(Locale.ROOT).getBytes(charset) : null;
        this.userBytes = user.getBytes(charset);
    }

    int getType2Flags() {
        return this.type2Flags;
    }

    byte[] getExportedSessionKey() {
        return this.exportedSessionKey;
    }

    @Override
    protected void buildMessage() {
        int ntRespLen = this.ntResp.length;
        int lmRespLen = this.lmResp.length;
        int domainLen = this.domainBytes != null ? this.domainBytes.length : 0;
        int hostLen = this.hostBytes != null ? this.hostBytes.length : 0;
        int userLen = this.userBytes.length;
        int sessionKeyLen = this.sessionKey != null ? this.sessionKey.length : 0;
        int lmRespOffset = 72;
        int ntRespOffset = 72 + lmRespLen;
        int domainOffset = ntRespOffset + ntRespLen;
        int userOffset = domainOffset + domainLen;
        int hostOffset = userOffset + userLen;
        int sessionKeyOffset = hostOffset + hostLen;
        int finalLength = sessionKeyOffset + sessionKeyLen;
        this.prepareResponse(finalLength, 3);
        this.addUShort(lmRespLen);
        this.addUShort(lmRespLen);
        this.addULong(72);
        this.addUShort(ntRespLen);
        this.addUShort(ntRespLen);
        this.addULong(ntRespOffset);
        this.addUShort(domainLen);
        this.addUShort(domainLen);
        this.addULong(domainOffset);
        this.addUShort(userLen);
        this.addUShort(userLen);
        this.addULong(userOffset);
        this.addUShort(hostLen);
        this.addUShort(hostLen);
        this.addULong(hostOffset);
        this.addUShort(sessionKeyLen);
        this.addUShort(sessionKeyLen);
        this.addULong(sessionKeyOffset);
        this.addULong(this.type2Flags);
        this.addUShort(261);
        this.addULong(2600);
        this.addUShort(3840);
        this.addBytes(this.lmResp);
        this.addBytes(this.ntResp);
        this.addBytes(this.domainBytes);
        this.addBytes(this.userBytes);
        this.addBytes(this.hostBytes);
        if (this.sessionKey != null) {
            this.addBytes(this.sessionKey);
        }
    }

    static {
        SecureRandom rnd = null;
        try {
            rnd = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception exception) {
            // empty catch block
        }
        RND_GEN = rnd;
    }
}

