/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.winrm.service.client.encryption;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.Address;
import org.apache.cxf.transport.http.asyncclient.AsyncHTTPConduit;
import org.apache.cxf.transport.http.asyncclient.AsyncHTTPConduitFactory;
import org.apache.cxf.transport.http.asyncclient.CXFHttpRequest;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.http.HttpEntity;
import org.apache.http.auth.Credentials;
import org.apache.http.client.config.RequestConfig;
import org.sentrysoftware.winrm.service.client.encryption.AsyncHttpEncryptionAwareConduitFactory;
import org.sentrysoftware.winrm.service.client.encryption.ContentWithType;
import org.sentrysoftware.winrm.service.client.encryption.EncryptAndSignOutputStream;
import org.sentrysoftware.winrm.service.client.encryption.EncryptionAwareHttpEntity;
import org.sentrysoftware.winrm.service.client.encryption.NtlmEncryptionUtils;

public class AsyncHttpEncryptionAwareConduit
extends AsyncHTTPConduit {
    static final byte[] PRE_AUTH_BOGUS_PAYLOAD = "AWAITING_ENCRYPTION_KEYS".getBytes();
    private static final List<String> TARGET_AUTH_SCHEMES = Arrays.asList("Negotiate", "Kerberos");

    private static ContentWithType getAppropriate(Message msg) {
        EncryptAndSignOutputStream encryptingStream = (EncryptAndSignOutputStream)((Object)msg.getContent(EncryptAndSignOutputStream.class));
        if (encryptingStream == null) {
            throw new IllegalStateException("No SignAndEncryptOutInterceptor applied to message");
        }
        return encryptingStream.getAppropriate();
    }

    public AsyncHttpEncryptionAwareConduit(Bus bus, EndpointInfo endpointInfo, EndpointReferenceType endpointReferenceType, AsyncHttpEncryptionAwareConduitFactory factory) throws IOException {
        super(bus, endpointInfo, endpointReferenceType, (AsyncHTTPConduitFactory)factory);
    }

    protected OutputStream createOutputStream(Message message, boolean needToCacheRequest, boolean isChunking, int chunkThreshold) throws IOException {
        NtlmEncryptionUtils encryptor = NtlmEncryptionUtils.of((Credentials)message.get(Credentials.class));
        if (encryptor == null) {
            return super.createOutputStream(message, needToCacheRequest, isChunking, chunkThreshold);
        }
        if (Boolean.TRUE.equals(message.get((Object)"use.async.http.conduit"))) {
            CXFHttpRequest requestEntity = (CXFHttpRequest)message.get(CXFHttpRequest.class);
            AsyncWrappedEncryptionAwareOutputStream out = new AsyncWrappedEncryptionAwareOutputStream(message, true, false, chunkThreshold, this.getConduitName(), requestEntity.getURI());
            requestEntity.setOutputStream((AsyncHTTPConduit.AsyncWrappedOutputStream)out);
            return out;
        }
        throw new IllegalStateException("Encryption only available with ASYNC at present");
    }

    protected void setupConnection(final Message message, Address address, HTTPClientPolicy csPolicy) throws IOException {
        super.setupConnection(message, address, csPolicy);
        final CXFHttpRequest requestEntity = (CXFHttpRequest)message.get(CXFHttpRequest.class);
        EncryptionAwareHttpEntity entity = new EncryptionAwareHttpEntity(){

            public boolean isRepeatable() {
                return requestEntity.getOutputStream().retransmitable();
            }

            @Override
            protected ContentWithType getAppropriate() {
                return AsyncHttpEncryptionAwareConduit.getAppropriate(message);
            }
        };
        entity.setChunked(true);
        entity.setContentType((String)message.get((Object)"Content-Type"));
        requestEntity.setEntity((HttpEntity)entity);
        requestEntity.setConfig(RequestConfig.copy((RequestConfig)requestEntity.getConfig()).setTargetPreferredAuthSchemes(TARGET_AUTH_SCHEMES).build());
    }

    private class AsyncWrappedEncryptionAwareOutputStream
    extends AsyncHTTPConduit.AsyncWrappedOutputStream {
        public AsyncWrappedEncryptionAwareOutputStream(Message message, boolean needToCacheRequest, boolean isChunking, int chunkThreshold, String conduitName, URI uri) {
            super((AsyncHTTPConduit)AsyncHttpEncryptionAwareConduit.this, message, needToCacheRequest, isChunking, chunkThreshold, conduitName, uri);
        }

        protected void setupWrappedStream() throws IOException {
            super.setupWrappedStream();
            if (!(this.cachedStream.getFlowThroughStream() instanceof EncryptionAwareCacheAndWriteOutputStream)) {
                this.cachedStream = new EncryptionAwareCacheAndWriteOutputStream(this.cachedStream.getFlowThroughStream());
                this.wrappedStream = this.cachedStream;
            }
        }

        private class EncryptionAwareCacheAndWriteOutputStream
        extends CacheAndWriteOutputStream {
            public EncryptionAwareCacheAndWriteOutputStream(OutputStream outbufFlowThroughStream) {
                super(outbufFlowThroughStream);
            }

            public byte[] getBytes() throws IOException {
                ContentWithType appropriate = AsyncHttpEncryptionAwareConduit.getAppropriate(AsyncWrappedEncryptionAwareOutputStream.this.outMessage);
                return appropriate.getPayload();
            }

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(this.getBytes());
            }
        }
    }
}

