/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.winrm.service.client.encryption;

import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.impl.auth.NTLMEngineException;
import org.sentrysoftware.winrm.service.client.auth.ntlm.NTLMEngineUtils;
import org.sentrysoftware.winrm.service.client.encryption.EncryptionUtils;
import org.sentrysoftware.winrm.service.client.encryption.HMACMD5;
import org.sentrysoftware.winrm.service.client.encryption.MD4;

public class CipherGen {
    private final Random random;
    private final long currentTime;
    private final String domain;
    private final String user;
    private final String password;
    private final byte[] challenge;
    private final byte[] targetInformation;
    private byte[] clientChallenge;
    private byte[] clientChallenge2;
    private byte[] secondaryKey;
    private byte[] timestamp;
    private byte[] lmHash = null;
    private byte[] lmResponse = null;
    private byte[] ntlmHash = null;
    private byte[] ntlmResponse = null;
    private byte[] ntlmv2Hash = null;
    private byte[] lmv2Hash = null;
    private byte[] lmv2Response = null;
    private byte[] ntlmv2Blob = null;
    private byte[] ntlmv2Response = null;
    private byte[] ntlm2SessionResponse = null;
    private byte[] lm2SessionResponse = null;
    private byte[] lmUserSessionKey = null;
    private byte[] ntlmUserSessionKey = null;
    private byte[] ntlmv2UserSessionKey = null;
    private byte[] ntlm2SessionResponseUserSessionKey = null;
    private byte[] lanManagerSessionKey = null;

    public CipherGen(Random random, long currentTime, String domain, String user, String password, byte[] challenge, String target, byte[] targetInformation) {
        this.random = random;
        this.currentTime = currentTime;
        this.domain = domain;
        this.user = user;
        this.password = password;
        this.challenge = challenge;
        this.targetInformation = targetInformation;
    }

    private byte[] getClientChallenge() {
        if (this.clientChallenge == null) {
            this.clientChallenge = CipherGen.makeRandomChallenge(this.random);
        }
        return this.clientChallenge;
    }

    private byte[] getClientChallenge2() {
        if (this.clientChallenge2 == null) {
            this.clientChallenge2 = CipherGen.makeRandomChallenge(this.random);
        }
        return this.clientChallenge2;
    }

    public byte[] getSecondaryKey() {
        if (this.secondaryKey == null) {
            this.secondaryKey = CipherGen.makeSecondaryKey(this.random);
        }
        return this.secondaryKey;
    }

    private byte[] getLMHash() throws NTLMEngineException {
        if (this.lmHash == null) {
            this.lmHash = CipherGen.lmHash(this.password);
        }
        return this.lmHash;
    }

    public byte[] getLMResponse() throws NTLMEngineException {
        if (this.lmResponse == null) {
            this.lmResponse = CipherGen.lmResponse(this.getLMHash(), this.challenge);
        }
        return this.lmResponse;
    }

    private byte[] getNTLMHash() throws NTLMEngineException {
        if (this.ntlmHash == null) {
            this.ntlmHash = CipherGen.ntlmHash(this.password);
        }
        return this.ntlmHash;
    }

    public byte[] getNTLMResponse() throws NTLMEngineException {
        if (this.ntlmResponse == null) {
            this.ntlmResponse = CipherGen.lmResponse(this.getNTLMHash(), this.challenge);
        }
        return this.ntlmResponse;
    }

    private byte[] getLMv2Hash() throws NTLMEngineException {
        if (this.lmv2Hash == null) {
            this.lmv2Hash = CipherGen.lmv2Hash(this.domain, this.user, this.getNTLMHash());
        }
        return this.lmv2Hash;
    }

    private byte[] getNTLMv2Hash() throws NTLMEngineException {
        if (this.ntlmv2Hash == null) {
            this.ntlmv2Hash = CipherGen.ntlmv2Hash(this.domain, this.user, this.getNTLMHash());
        }
        return this.ntlmv2Hash;
    }

    private byte[] getTimestamp() {
        if (this.timestamp == null) {
            long time = this.currentTime;
            time += 11644473600000L;
            time *= 10000L;
            this.timestamp = new byte[8];
            for (int i = 0; i < 8; ++i) {
                this.timestamp[i] = (byte)time;
                time >>>= 8;
            }
        }
        return this.timestamp;
    }

    private byte[] getNTLMv2Blob() {
        if (this.ntlmv2Blob == null) {
            this.ntlmv2Blob = CipherGen.createBlob(this.getClientChallenge2(), this.targetInformation, this.getTimestamp());
        }
        return this.ntlmv2Blob;
    }

    private static byte[] createBlob(byte[] clientChallenge, byte[] targetInformation, byte[] timestamp) {
        byte[] blobSignature = new byte[]{1, 1, 0, 0};
        byte[] reserved = new byte[]{0, 0, 0, 0};
        byte[] unknown1 = new byte[]{0, 0, 0, 0};
        byte[] unknown2 = new byte[]{0, 0, 0, 0};
        byte[] blob = new byte[blobSignature.length + reserved.length + timestamp.length + 8 + unknown1.length + targetInformation.length + unknown2.length];
        int offset = 0;
        System.arraycopy(blobSignature, 0, blob, offset, blobSignature.length);
        System.arraycopy(reserved, 0, blob, offset += blobSignature.length, reserved.length);
        System.arraycopy(timestamp, 0, blob, offset += reserved.length, timestamp.length);
        System.arraycopy(clientChallenge, 0, blob, offset += timestamp.length, 8);
        System.arraycopy(unknown1, 0, blob, offset += 8, unknown1.length);
        System.arraycopy(targetInformation, 0, blob, offset += unknown1.length, targetInformation.length);
        System.arraycopy(unknown2, 0, blob, offset += targetInformation.length, unknown2.length);
        offset += unknown2.length;
        return blob;
    }

    public byte[] getNTLMv2Response() throws NTLMEngineException {
        if (this.ntlmv2Response == null) {
            this.ntlmv2Response = CipherGen.lmv2Response(this.getNTLMv2Hash(), this.challenge, this.getNTLMv2Blob());
        }
        return this.ntlmv2Response;
    }

    public byte[] getLMv2Response() throws NTLMEngineException {
        if (this.lmv2Response == null) {
            this.lmv2Response = CipherGen.lmv2Response(this.getLMv2Hash(), this.challenge, this.getClientChallenge());
        }
        return this.lmv2Response;
    }

    public byte[] getNTLM2SessionResponse() throws NTLMEngineException {
        if (this.ntlm2SessionResponse == null) {
            this.ntlm2SessionResponse = CipherGen.ntlm2SessionResponse(this.getNTLMHash(), this.challenge, this.getClientChallenge());
        }
        return this.ntlm2SessionResponse;
    }

    private static byte[] ntlm2SessionResponse(byte[] ntlmHash, byte[] challenge, byte[] clientChallenge) throws NTLMEngineException {
        try {
            MessageDigest md5 = EncryptionUtils.getMD5();
            md5.update(challenge);
            md5.update(clientChallenge);
            byte[] digest = md5.digest();
            byte[] sessionHash = new byte[8];
            System.arraycopy(digest, 0, sessionHash, 0, 8);
            return CipherGen.lmResponse(ntlmHash, sessionHash);
        }
        catch (NTLMEngineException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NTLMEngineException(e.getMessage(), (Throwable)e);
        }
    }

    private static byte[] lmResponse(byte[] hash, byte[] challenge) throws NTLMEngineException {
        try {
            byte[] keyBytes = new byte[21];
            System.arraycopy(hash, 0, keyBytes, 0, 16);
            Key lowKey = CipherGen.createDESKey(keyBytes, 0);
            Key middleKey = CipherGen.createDESKey(keyBytes, 7);
            Key highKey = CipherGen.createDESKey(keyBytes, 14);
            Cipher des = Cipher.getInstance("DES/ECB/NoPadding");
            des.init(1, lowKey);
            byte[] lowResponse = des.doFinal(challenge);
            des.init(1, middleKey);
            byte[] middleResponse = des.doFinal(challenge);
            des.init(1, highKey);
            byte[] highResponse = des.doFinal(challenge);
            byte[] lmResponse = new byte[24];
            System.arraycopy(lowResponse, 0, lmResponse, 0, 8);
            System.arraycopy(middleResponse, 0, lmResponse, 8, 8);
            System.arraycopy(highResponse, 0, lmResponse, 16, 8);
            return lmResponse;
        }
        catch (Exception e) {
            throw new NTLMEngineException(e.getMessage(), (Throwable)e);
        }
    }

    private static byte[] lmHash(String password) throws NTLMEngineException {
        try {
            byte[] oemPassword = password.toUpperCase(Locale.ROOT).getBytes(NTLMEngineUtils.DEFAULT_CHARSET);
            int length = Math.min(oemPassword.length, 14);
            byte[] keyBytes = new byte[14];
            System.arraycopy(oemPassword, 0, keyBytes, 0, length);
            Key lowKey = CipherGen.createDESKey(keyBytes, 0);
            Key highKey = CipherGen.createDESKey(keyBytes, 7);
            byte[] magicConstant = "KGS!@#$%".getBytes(NTLMEngineUtils.DEFAULT_CHARSET);
            Cipher des = Cipher.getInstance("DES/ECB/NoPadding");
            des.init(1, lowKey);
            byte[] lowHash = des.doFinal(magicConstant);
            des.init(1, highKey);
            byte[] highHash = des.doFinal(magicConstant);
            byte[] lmHash = new byte[16];
            System.arraycopy(lowHash, 0, lmHash, 0, 8);
            System.arraycopy(highHash, 0, lmHash, 8, 8);
            return lmHash;
        }
        catch (Exception e) {
            throw new NTLMEngineException(e.getMessage(), (Throwable)e);
        }
    }

    private static Key createDESKey(byte[] bytes, int offset) {
        byte[] keyBytes = new byte[7];
        System.arraycopy(bytes, offset, keyBytes, 0, 7);
        byte[] material = new byte[]{keyBytes[0], (byte)(keyBytes[0] << 7 | (keyBytes[1] & 0xFF) >>> 1), (byte)(keyBytes[1] << 6 | (keyBytes[2] & 0xFF) >>> 2), (byte)(keyBytes[2] << 5 | (keyBytes[3] & 0xFF) >>> 3), (byte)(keyBytes[3] << 4 | (keyBytes[4] & 0xFF) >>> 4), (byte)(keyBytes[4] << 3 | (keyBytes[5] & 0xFF) >>> 5), (byte)(keyBytes[5] << 2 | (keyBytes[6] & 0xFF) >>> 6), (byte)(keyBytes[6] << 1)};
        CipherGen.oddParity(material);
        return new SecretKeySpec(material, "DES");
    }

    private static void oddParity(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            boolean needsParity;
            byte b = bytes[i];
            boolean bl = needsParity = ((b >>> 7 ^ b >>> 6 ^ b >>> 5 ^ b >>> 4 ^ b >>> 3 ^ b >>> 2 ^ b >>> 1) & 1) == 0;
            if (needsParity) {
                int n = i;
                bytes[n] = (byte)(bytes[n] | 1);
                continue;
            }
            int n = i;
            bytes[n] = (byte)(bytes[n] & 0xFFFFFFFE);
        }
    }

    public byte[] getLM2SessionResponse() {
        if (this.lm2SessionResponse == null) {
            byte[] clntChallenge = this.getClientChallenge();
            this.lm2SessionResponse = new byte[24];
            System.arraycopy(clntChallenge, 0, this.lm2SessionResponse, 0, clntChallenge.length);
            Arrays.fill(this.lm2SessionResponse, clntChallenge.length, this.lm2SessionResponse.length, (byte)0);
        }
        return this.lm2SessionResponse;
    }

    public byte[] getLMUserSessionKey() throws NTLMEngineException {
        if (this.lmUserSessionKey == null) {
            this.lmUserSessionKey = new byte[16];
            System.arraycopy(this.getLMHash(), 0, this.lmUserSessionKey, 0, 8);
            Arrays.fill(this.lmUserSessionKey, 8, 16, (byte)0);
        }
        return this.lmUserSessionKey;
    }

    public byte[] getNTLMUserSessionKey() throws NTLMEngineException {
        if (this.ntlmUserSessionKey == null) {
            MD4 md4 = new MD4();
            md4.update(this.getNTLMHash());
            this.ntlmUserSessionKey = md4.getOutput();
        }
        return this.ntlmUserSessionKey;
    }

    public byte[] getNTLMv2UserSessionKey() throws NTLMEngineException {
        if (this.ntlmv2UserSessionKey == null) {
            byte[] ntlmv2hash = this.getNTLMv2Hash();
            byte[] truncatedResponse = new byte[16];
            System.arraycopy(this.getNTLMv2Response(), 0, truncatedResponse, 0, 16);
            this.ntlmv2UserSessionKey = CipherGen.hmacMD5(truncatedResponse, ntlmv2hash);
        }
        return this.ntlmv2UserSessionKey;
    }

    public byte[] getNTLM2SessionResponseUserSessionKey() throws NTLMEngineException {
        if (this.ntlm2SessionResponseUserSessionKey == null) {
            byte[] ntlm2SessionResponseNonce = this.getLM2SessionResponse();
            byte[] sessionNonce = new byte[this.challenge.length + ntlm2SessionResponseNonce.length];
            System.arraycopy(this.challenge, 0, sessionNonce, 0, this.challenge.length);
            System.arraycopy(ntlm2SessionResponseNonce, 0, sessionNonce, this.challenge.length, ntlm2SessionResponseNonce.length);
            this.ntlm2SessionResponseUserSessionKey = CipherGen.hmacMD5(sessionNonce, this.getNTLMUserSessionKey());
        }
        return this.ntlm2SessionResponseUserSessionKey;
    }

    public byte[] getLanManagerSessionKey() throws NTLMEngineException {
        if (this.lanManagerSessionKey == null) {
            try {
                byte[] keyBytes = new byte[14];
                System.arraycopy(this.getLMHash(), 0, keyBytes, 0, 8);
                Arrays.fill(keyBytes, 8, keyBytes.length, (byte)-67);
                Key lowKey = CipherGen.createDESKey(keyBytes, 0);
                Key highKey = CipherGen.createDESKey(keyBytes, 7);
                byte[] truncatedResponse = new byte[8];
                System.arraycopy(this.getLMResponse(), 0, truncatedResponse, 0, truncatedResponse.length);
                Cipher des = Cipher.getInstance("DES/ECB/NoPadding");
                des.init(1, lowKey);
                byte[] lowPart = des.doFinal(truncatedResponse);
                des = Cipher.getInstance("DES/ECB/NoPadding");
                des.init(1, highKey);
                byte[] highPart = des.doFinal(truncatedResponse);
                this.lanManagerSessionKey = new byte[16];
                System.arraycopy(lowPart, 0, this.lanManagerSessionKey, 0, lowPart.length);
                System.arraycopy(highPart, 0, this.lanManagerSessionKey, lowPart.length, highPart.length);
            }
            catch (Exception e) {
                throw new NTLMEngineException(e.getMessage(), (Throwable)e);
            }
        }
        return this.lanManagerSessionKey;
    }

    private static byte[] ntlmHash(String password) throws NTLMEngineException {
        if (NTLMEngineUtils.UNICODE_LITTLE_UNMARKED == null) {
            throw new NTLMEngineException("Unicode not supported");
        }
        byte[] unicodePassword = password.getBytes(NTLMEngineUtils.UNICODE_LITTLE_UNMARKED);
        MD4 md4 = new MD4();
        md4.update(unicodePassword);
        return md4.getOutput();
    }

    private static byte[] lmv2Hash(String domain, String user, byte[] ntlmHash) throws NTLMEngineException {
        if (NTLMEngineUtils.UNICODE_LITTLE_UNMARKED == null) {
            throw new NTLMEngineException("Unicode not supported");
        }
        HMACMD5 hmacMD5 = new HMACMD5(ntlmHash);
        hmacMD5.update(user.toUpperCase(Locale.ROOT).getBytes(NTLMEngineUtils.UNICODE_LITTLE_UNMARKED));
        if (domain != null) {
            hmacMD5.update(domain.toUpperCase(Locale.ROOT).getBytes(NTLMEngineUtils.UNICODE_LITTLE_UNMARKED));
        }
        return hmacMD5.getOutput();
    }

    private static byte[] ntlmv2Hash(String domain, String user, byte[] ntlmHash) throws NTLMEngineException {
        if (NTLMEngineUtils.UNICODE_LITTLE_UNMARKED == null) {
            throw new NTLMEngineException("Unicode not supported");
        }
        HMACMD5 hmacMD5 = new HMACMD5(ntlmHash);
        hmacMD5.update(user.toUpperCase(Locale.ROOT).getBytes(NTLMEngineUtils.UNICODE_LITTLE_UNMARKED));
        if (domain != null) {
            hmacMD5.update(domain.getBytes(NTLMEngineUtils.UNICODE_LITTLE_UNMARKED));
        }
        return hmacMD5.getOutput();
    }

    private static byte[] lmv2Response(byte[] hash, byte[] challenge, byte[] clientData) {
        HMACMD5 hmacMD5 = new HMACMD5(hash);
        hmacMD5.update(challenge);
        hmacMD5.update(clientData);
        byte[] mac = hmacMD5.getOutput();
        byte[] lmv2Response = new byte[mac.length + clientData.length];
        System.arraycopy(mac, 0, lmv2Response, 0, mac.length);
        System.arraycopy(clientData, 0, lmv2Response, mac.length, clientData.length);
        return lmv2Response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] makeRandomChallenge(Random random) {
        byte[] rval = new byte[8];
        Random random2 = random;
        synchronized (random2) {
            random.nextBytes(rval);
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] makeSecondaryKey(Random random) {
        byte[] rval = new byte[16];
        Random random2 = random;
        synchronized (random2) {
            random.nextBytes(rval);
        }
        return rval;
    }

    private static byte[] hmacMD5(byte[] value, byte[] key) {
        HMACMD5 hmacMD5 = new HMACMD5(key);
        hmacMD5.update(value);
        return hmacMD5.getOutput();
    }
}

