/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.winrm.service.client.encryption;

public class MD4 {
    private int a = 1732584193;
    private int b = -271733879;
    private int c = -1732584194;
    private int d = 271733878;
    private long count = 0L;
    private final byte[] dataBuffer = new byte[64];

    void update(byte[] input) {
        int transferAmt;
        int curBufferPos = (int)(this.count & 0x3FL);
        int inputIndex = 0;
        while (input.length - inputIndex + curBufferPos >= this.dataBuffer.length) {
            transferAmt = this.dataBuffer.length - curBufferPos;
            System.arraycopy(input, inputIndex, this.dataBuffer, curBufferPos, transferAmt);
            this.count += (long)transferAmt;
            curBufferPos = 0;
            inputIndex += transferAmt;
            this.processBuffer();
        }
        if (inputIndex < input.length) {
            transferAmt = input.length - inputIndex;
            System.arraycopy(input, inputIndex, this.dataBuffer, curBufferPos, transferAmt);
            this.count += (long)transferAmt;
            curBufferPos += transferAmt;
        }
    }

    byte[] getOutput() {
        int bufferIndex = (int)(this.count & 0x3FL);
        int padLen = bufferIndex < 56 ? 56 - bufferIndex : 120 - bufferIndex;
        byte[] postBytes = new byte[padLen + 8];
        postBytes[0] = -128;
        for (int i = 0; i < 8; ++i) {
            postBytes[padLen + i] = (byte)(this.count * 8L >>> 8 * i);
        }
        this.update(postBytes);
        byte[] result = new byte[16];
        MD4.writeULong(result, this.a, 0);
        MD4.writeULong(result, this.b, 4);
        MD4.writeULong(result, this.c, 8);
        MD4.writeULong(result, this.d, 12);
        return result;
    }

    private static void writeULong(byte[] buffer, int value, int offset) {
        buffer[offset] = (byte)(value & 0xFF);
        buffer[offset + 1] = (byte)(value >> 8 & 0xFF);
        buffer[offset + 2] = (byte)(value >> 16 & 0xFF);
        buffer[offset + 3] = (byte)(value >> 24 & 0xFF);
    }

    private void processBuffer() {
        int[] d = new int[16];
        for (int i = 0; i < 16; ++i) {
            d[i] = (this.dataBuffer[i * 4] & 0xFF) + ((this.dataBuffer[i * 4 + 1] & 0xFF) << 8) + ((this.dataBuffer[i * 4 + 2] & 0xFF) << 16) + ((this.dataBuffer[i * 4 + 3] & 0xFF) << 24);
        }
        int aa = this.a;
        int bb = this.b;
        int cc = this.c;
        int dd = this.d;
        this.round1(d);
        this.round2(d);
        this.round3(d);
        this.a += aa;
        this.b += bb;
        this.c += cc;
        this.d += dd;
    }

    private void round1(int[] d) {
        this.a = MD4.rotintlft(this.a + MD4.f(this.b, this.c, this.d) + d[0], 3);
        this.d = MD4.rotintlft(this.d + MD4.f(this.a, this.b, this.c) + d[1], 7);
        this.c = MD4.rotintlft(this.c + MD4.f(this.d, this.a, this.b) + d[2], 11);
        this.b = MD4.rotintlft(this.b + MD4.f(this.c, this.d, this.a) + d[3], 19);
        this.a = MD4.rotintlft(this.a + MD4.f(this.b, this.c, this.d) + d[4], 3);
        this.d = MD4.rotintlft(this.d + MD4.f(this.a, this.b, this.c) + d[5], 7);
        this.c = MD4.rotintlft(this.c + MD4.f(this.d, this.a, this.b) + d[6], 11);
        this.b = MD4.rotintlft(this.b + MD4.f(this.c, this.d, this.a) + d[7], 19);
        this.a = MD4.rotintlft(this.a + MD4.f(this.b, this.c, this.d) + d[8], 3);
        this.d = MD4.rotintlft(this.d + MD4.f(this.a, this.b, this.c) + d[9], 7);
        this.c = MD4.rotintlft(this.c + MD4.f(this.d, this.a, this.b) + d[10], 11);
        this.b = MD4.rotintlft(this.b + MD4.f(this.c, this.d, this.a) + d[11], 19);
        this.a = MD4.rotintlft(this.a + MD4.f(this.b, this.c, this.d) + d[12], 3);
        this.d = MD4.rotintlft(this.d + MD4.f(this.a, this.b, this.c) + d[13], 7);
        this.c = MD4.rotintlft(this.c + MD4.f(this.d, this.a, this.b) + d[14], 11);
        this.b = MD4.rotintlft(this.b + MD4.f(this.c, this.d, this.a) + d[15], 19);
    }

    private void round2(int[] d) {
        this.a = MD4.rotintlft(this.a + MD4.g(this.b, this.c, this.d) + d[0] + 1518500249, 3);
        this.d = MD4.rotintlft(this.d + MD4.g(this.a, this.b, this.c) + d[4] + 1518500249, 5);
        this.c = MD4.rotintlft(this.c + MD4.g(this.d, this.a, this.b) + d[8] + 1518500249, 9);
        this.b = MD4.rotintlft(this.b + MD4.g(this.c, this.d, this.a) + d[12] + 1518500249, 13);
        this.a = MD4.rotintlft(this.a + MD4.g(this.b, this.c, this.d) + d[1] + 1518500249, 3);
        this.d = MD4.rotintlft(this.d + MD4.g(this.a, this.b, this.c) + d[5] + 1518500249, 5);
        this.c = MD4.rotintlft(this.c + MD4.g(this.d, this.a, this.b) + d[9] + 1518500249, 9);
        this.b = MD4.rotintlft(this.b + MD4.g(this.c, this.d, this.a) + d[13] + 1518500249, 13);
        this.a = MD4.rotintlft(this.a + MD4.g(this.b, this.c, this.d) + d[2] + 1518500249, 3);
        this.d = MD4.rotintlft(this.d + MD4.g(this.a, this.b, this.c) + d[6] + 1518500249, 5);
        this.c = MD4.rotintlft(this.c + MD4.g(this.d, this.a, this.b) + d[10] + 1518500249, 9);
        this.b = MD4.rotintlft(this.b + MD4.g(this.c, this.d, this.a) + d[14] + 1518500249, 13);
        this.a = MD4.rotintlft(this.a + MD4.g(this.b, this.c, this.d) + d[3] + 1518500249, 3);
        this.d = MD4.rotintlft(this.d + MD4.g(this.a, this.b, this.c) + d[7] + 1518500249, 5);
        this.c = MD4.rotintlft(this.c + MD4.g(this.d, this.a, this.b) + d[11] + 1518500249, 9);
        this.b = MD4.rotintlft(this.b + MD4.g(this.c, this.d, this.a) + d[15] + 1518500249, 13);
    }

    private void round3(int[] d) {
        this.a = MD4.rotintlft(this.a + MD4.h(this.b, this.c, this.d) + d[0] + 1859775393, 3);
        this.d = MD4.rotintlft(this.d + MD4.h(this.a, this.b, this.c) + d[8] + 1859775393, 9);
        this.c = MD4.rotintlft(this.c + MD4.h(this.d, this.a, this.b) + d[4] + 1859775393, 11);
        this.b = MD4.rotintlft(this.b + MD4.h(this.c, this.d, this.a) + d[12] + 1859775393, 15);
        this.a = MD4.rotintlft(this.a + MD4.h(this.b, this.c, this.d) + d[2] + 1859775393, 3);
        this.d = MD4.rotintlft(this.d + MD4.h(this.a, this.b, this.c) + d[10] + 1859775393, 9);
        this.c = MD4.rotintlft(this.c + MD4.h(this.d, this.a, this.b) + d[6] + 1859775393, 11);
        this.b = MD4.rotintlft(this.b + MD4.h(this.c, this.d, this.a) + d[14] + 1859775393, 15);
        this.a = MD4.rotintlft(this.a + MD4.h(this.b, this.c, this.d) + d[1] + 1859775393, 3);
        this.d = MD4.rotintlft(this.d + MD4.h(this.a, this.b, this.c) + d[9] + 1859775393, 9);
        this.c = MD4.rotintlft(this.c + MD4.h(this.d, this.a, this.b) + d[5] + 1859775393, 11);
        this.b = MD4.rotintlft(this.b + MD4.h(this.c, this.d, this.a) + d[13] + 1859775393, 15);
        this.a = MD4.rotintlft(this.a + MD4.h(this.b, this.c, this.d) + d[3] + 1859775393, 3);
        this.d = MD4.rotintlft(this.d + MD4.h(this.a, this.b, this.c) + d[11] + 1859775393, 9);
        this.c = MD4.rotintlft(this.c + MD4.h(this.d, this.a, this.b) + d[7] + 1859775393, 11);
        this.b = MD4.rotintlft(this.b + MD4.h(this.c, this.d, this.a) + d[15] + 1859775393, 15);
    }

    private static int f(int x, int y, int z) {
        return x & y | ~x & z;
    }

    private static int g(int x, int y, int z) {
        return x & y | x & z | y & z;
    }

    private static int h(int x, int y, int z) {
        return x ^ y ^ z;
    }

    private static int rotintlft(int val, int numbits) {
        return val << numbits | val >>> 32 - numbits;
    }
}

