/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.winrm.service.client.encryption;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.zip.CRC32;
import org.apache.cxf.message.Message;
import org.apache.http.auth.Credentials;
import org.sentrysoftware.winrm.service.client.auth.ntlm.NTCredentialsWithEncryption;
import org.sentrysoftware.winrm.service.client.encryption.ByteArrayUtils;
import org.sentrysoftware.winrm.service.client.encryption.Decryptor;
import org.sentrysoftware.winrm.service.client.encryption.EncryptionUtils;

public class NtlmEncryptionUtils {
    public static final String ENCRYPTED_BOUNDARY_PREFIX = "--Encrypted Boundary";
    public static final String ENCRYPTED_BOUNDARY_CR = "--Encrypted Boundary\r\n";
    public static final String ENCRYPTED_BOUNDARY_END = "--Encrypted Boundary--\r\n";
    protected final NTCredentialsWithEncryption credentials;

    private NtlmEncryptionUtils(NTCredentialsWithEncryption credentials) {
        this.credentials = credentials;
    }

    static NtlmEncryptionUtils of(Credentials credentials) {
        return credentials instanceof NTCredentialsWithEncryption ? new NtlmEncryptionUtils((NTCredentialsWithEncryption)credentials) : null;
    }

    static NtlmEncryptionUtils of(Message message) {
        Credentials credentials = (Credentials)message.getExchange().get((Object)Credentials.class.getName());
        return NtlmEncryptionUtils.of(credentials);
    }

    public byte[] encryptAndSign(Message message, byte[] messageBody) {
        byte[] byArray;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(ENCRYPTED_BOUNDARY_CR.getBytes());
            out.write("\tContent-Type: application/HTTP-SPNEGO-session-encrypted\r\n".getBytes());
            out.write(String.format("\tOriginalContent: type=application/soap+xml;charset=UTF-8;Length=%d\r\n", messageBody.length).getBytes());
            out.write(ENCRYPTED_BOUNDARY_CR.getBytes());
            out.write("\tContent-Type: application/octet-stream\r\n".getBytes());
            this.writeNtlmEncrypted(messageBody, out);
            out.write(ENCRYPTED_BOUNDARY_END.getBytes());
            message.put((Object)"Content-Type", (Object)"multipart/encrypted;protocol=\"application/HTTP-SPNEGO-session-encrypted\";boundary=\"Encrypted Boundary\"");
            message.put((Object)Message.ENCODING, null);
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot encrypt WinRM message", e);
            }
        }
        out.close();
        return byArray;
    }

    private byte[] seal(byte[] in) {
        return this.credentials.getStatefulEncryptor().update(in);
    }

    private void writeNtlmEncrypted(byte[] messageBody, ByteArrayOutputStream encrypted) throws IOException {
        long seqNum = this.credentials.getSequenceNumberOutgoing().incrementAndGet();
        try (ByteArrayOutputStream signature = new ByteArrayOutputStream();
             ByteArrayOutputStream sealed = new ByteArrayOutputStream();){
            sealed.write(this.seal(messageBody));
            NtlmEncryptionUtils.calculateSignature(messageBody, seqNum, signature, this.credentials, NTCredentialsWithEncryption::getClientSigningKey, this::seal);
            encrypted.write(ByteArrayUtils.getLittleEndianUnsignedInt(signature.size()));
            encrypted.write(signature.toByteArray());
            encrypted.write(sealed.toByteArray());
        }
    }

    public void decrypt(Message message) {
        new Decryptor(this.credentials).handle(message);
    }

    static void calculateSignature(byte[] messageBody, long seqNum, ByteArrayOutputStream signature, NTCredentialsWithEncryption credentials, Function<NTCredentialsWithEncryption, byte[]> signingKeyFunction, UnaryOperator<byte[]> sealer) throws IOException {
        if (credentials.hasNegotiateFlag(524288L)) {
            byte[] checksum = EncryptionUtils.hmacMd5(signingKeyFunction.apply(credentials), ByteArrayUtils.concat(ByteArrayUtils.getLittleEndianUnsignedInt(seqNum), messageBody));
            checksum = Arrays.copyOfRange(checksum, 0, 8);
            if (credentials.hasNegotiateFlag(0x40000000L)) {
                checksum = (byte[])sealer.apply(checksum);
            }
            signature.write(new byte[]{1, 0, 0, 0});
            signature.write(checksum);
            signature.write(ByteArrayUtils.getLittleEndianUnsignedInt(seqNum));
        } else {
            CRC32 crc = new CRC32();
            crc.update(messageBody);
            long messageCrc = crc.getValue();
            signature.write(new byte[]{1, 0, 0, 0});
            signature.write((byte[])sealer.apply(ByteArrayUtils.getLittleEndianUnsignedInt(0L)));
            signature.write((byte[])sealer.apply(ByteArrayUtils.getLittleEndianUnsignedInt(messageCrc)));
            signature.write((byte[])sealer.apply(ByteArrayUtils.getLittleEndianUnsignedInt(seqNum)));
        }
    }
}

