/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.winrm.shares;

import com.hierynomus.security.SecurityProvider;
import com.hierynomus.security.bc.BCSecurityProvider;
import com.hierynomus.smbj.SMBClient;
import com.hierynomus.smbj.SmbConfig;
import com.hierynomus.smbj.auth.AuthenticationContext;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.DiskShare;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.sentrysoftware.winrm.Utils;
import org.sentrysoftware.winrm.WindowsRemoteExecutor;
import org.sentrysoftware.winrm.WindowsTempShare;
import org.sentrysoftware.winrm.exceptions.WinRMException;
import org.sentrysoftware.winrm.exceptions.WindowsRemoteException;
import org.sentrysoftware.winrm.service.WinRMEndpoint;
import org.sentrysoftware.winrm.service.WinRMService;
import org.sentrysoftware.winrm.service.client.auth.AuthenticationEnum;

public class SmbTempShare
extends WindowsTempShare
implements AutoCloseable {
    private final WinRMEndpoint winRMEndpoint;
    private final SMBClient smbClient;
    private final Connection connection;
    private final Session session;
    private final DiskShare diskShare;
    private static final ConcurrentHashMap<WinRMEndpoint, SmbTempShare> CONNECTIONS_CACHE = new ConcurrentHashMap();
    private final AtomicInteger useCount = new AtomicInteger(1);

    private SmbTempShare(WinRMService winRMService, WinRMEndpoint winRMEndpoint, SMBClient smbClient, Connection connection, Session session, DiskShare diskShare, String shareNameOrUnc, String remotePath) {
        super(winRMService, shareNameOrUnc, remotePath);
        this.winRMEndpoint = winRMEndpoint;
        this.smbClient = smbClient;
        this.connection = connection;
        this.session = session;
        this.diskShare = diskShare;
    }

    public static SmbTempShare createInstance(WinRMEndpoint winRMEndpoint, long timeout, Path ticketCache, List<AuthenticationEnum> authentications) throws IOException, WinRMException, TimeoutException {
        Utils.checkNonNull(winRMEndpoint, "winRMEndpoint");
        Utils.checkNonNull(winRMEndpoint.getPassword(), "password");
        Utils.checkArgumentNotZeroOrNegative(timeout, "timeout");
        try {
            return CONNECTIONS_CACHE.compute(winRMEndpoint, (key, smb) -> {
                if (smb == null) {
                    WinRMService winRMService = null;
                    SMBClient smbClient = null;
                    Connection connection = null;
                    Session session = null;
                    DiskShare diskShare = null;
                    try {
                        winRMService = WinRMService.createInstance(winRMEndpoint, timeout, ticketCache, authentications);
                        WindowsTempShare windowsTempShare = SmbTempShare.getOrCreateShare(winRMService, timeout, (w, r, s, t) -> {
                            try {
                                SmbTempShare.shareRemoteDirectory(w, r, s, t);
                            }
                            catch (TimeoutException | WindowsRemoteException e) {
                                throw new RuntimeException(e);
                            }
                        });
                        SmbConfig smbConfig = SmbConfig.builder().withSecurityProvider((SecurityProvider)new BCSecurityProvider()).withTimeout(timeout, TimeUnit.SECONDS).build();
                        AuthenticationContext authenticationContext = new AuthenticationContext(winRMEndpoint.getUsername(), winRMEndpoint.getPassword(), winRMEndpoint.getDomain());
                        smbClient = SmbTempShare.createSmbClient(smbConfig);
                        connection = smbClient.connect(winRMEndpoint.getHostname());
                        session = connection.authenticate(authenticationContext);
                        diskShare = (DiskShare)session.connectShare(windowsTempShare.getShareName());
                        return new SmbTempShare(winRMService, winRMEndpoint, smbClient, connection, session, diskShare, windowsTempShare.getUncSharePath(), windowsTempShare.getRemotePath());
                    }
                    catch (RuntimeException e) {
                        SmbTempShare.closeResources(winRMService, smbClient, connection, session, diskShare);
                        throw e;
                    }
                    catch (Exception e) {
                        SmbTempShare.closeResources(winRMService, smbClient, connection, session, diskShare);
                        throw new RuntimeException(e);
                    }
                }
                SmbTempShare smbTempShare = smb;
                synchronized (smbTempShare) {
                    smb.incrementUseCount();
                    return smb;
                }
            });
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof TimeoutException) {
                throw (TimeoutException)cause;
            }
            if (cause instanceof WindowsRemoteException) {
                throw (WinRMException)cause;
            }
            throw e;
        }
    }

    private static void closeResources(WinRMService winRMService, SMBClient smbClient, Connection connection, Session session, DiskShare diskShare) {
        try {
            if (diskShare != null) {
                diskShare.close();
            }
            if (session != null) {
                session.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        if (smbClient != null) {
            smbClient.close();
        }
        if (winRMService != null) {
            winRMService.close();
        }
    }

    int getUseCount() {
        return this.useCount.get();
    }

    void incrementUseCount() {
        this.useCount.incrementAndGet();
    }

    boolean isConnected() {
        return this.getUseCount() > 0;
    }

    public void checkConnectedFirst() {
        if (!this.isConnected()) {
            throw new IllegalStateException("This instance has been closed and a new one must be created.");
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.useCount.decrementAndGet() == 0) {
            CONNECTIONS_CACHE.remove(this.winRMEndpoint);
            if (this.diskShare != null) {
                this.diskShare.close();
            }
            if (this.session != null) {
                this.session.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
            if (this.smbClient != null) {
                this.smbClient.close();
            }
            ((WinRMService)this.getWindowsRemoteExecutor()).close();
        }
    }

    private static void shareRemoteDirectory(WindowsRemoteExecutor windowsRemoteExecutor, String remotePath, String shareName, long timeout) throws TimeoutException, WindowsRemoteException {
        String command = String.format("net share %s=%s /grant:%s,Full", shareName, remotePath, windowsRemoteExecutor.getUsername());
        windowsRemoteExecutor.executeCommand(command, null, null, timeout);
    }

    static SMBClient createSmbClient(SmbConfig smbConfig) {
        return new SMBClient(smbConfig);
    }
}

