/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.winrm.wql;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.sentrysoftware.winrm.Utils;
import org.sentrysoftware.winrm.WinRMHttpProtocolEnum;
import org.sentrysoftware.winrm.WmiHelper;
import org.sentrysoftware.winrm.exceptions.WinRMException;
import org.sentrysoftware.winrm.exceptions.WqlQuerySyntaxException;
import org.sentrysoftware.winrm.service.WinRMEndpoint;
import org.sentrysoftware.winrm.service.WinRMService;
import org.sentrysoftware.winrm.service.client.auth.AuthenticationEnum;

public class WinRMWqlExecutor {
    private final long executionTime;
    private final List<String> headers;
    private final List<List<String>> rows;

    public WinRMWqlExecutor(long executionTime, List<String> headers, List<List<String>> rows) {
        this.executionTime = executionTime;
        this.headers = headers;
        this.rows = rows;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public List<List<String>> getRows() {
        return this.rows;
    }

    public static WinRMWqlExecutor executeWql(WinRMHttpProtocolEnum protocol, String hostname, Integer port, String username, char[] password, String namespace, String wqlQuery, long timeout, Path ticketCache, List<AuthenticationEnum> authentications) throws WinRMException, WqlQuerySyntaxException, TimeoutException {
        Utils.checkNonNull(wqlQuery, "wqlQuery");
        Utils.checkArgumentNotZeroOrNegative(timeout, "timeout");
        long start = Utils.getCurrentTimeMillis();
        WinRMEndpoint winRMEndpoint = new WinRMEndpoint(protocol, hostname, port, username, password, namespace);
        try (WinRMService winRMService = WinRMService.createInstance(winRMEndpoint, timeout, ticketCache, authentications);){
            List<Map<String, Object>> result = winRMService.executeWql(wqlQuery, timeout);
            List<String> headers = WmiHelper.extractPropertiesFromResult(result, wqlQuery);
            List<List<String>> rows = result.stream().map(row -> headers.stream().map(header -> (String)row.get(header)).collect(Collectors.toList())).collect(Collectors.toList());
            WinRMWqlExecutor winRMWqlExecutor = new WinRMWqlExecutor(Utils.getCurrentTimeMillis() - start, headers, rows);
            return winRMWqlExecutor;
        }
    }
}

