/*
 * Copyright 2020 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.seppiko.commons.utils;

/**
 * @author Leonard Woo
 */
public class TypeUtil {

  public static Class<?> typeCheck(Object obj) {
    if (obj instanceof Boolean) {
      return Boolean.TYPE;
    }
    if (obj instanceof Byte) {
      return Byte.TYPE;
    }
    if (obj instanceof Short) {
      return Short.TYPE;
    }
    if (obj instanceof Integer) {
      return Integer.TYPE;
    }
    if (obj instanceof Long) {
      return Long.TYPE;
    }
    if (obj instanceof Float) {
      return Float.TYPE;
    }
    if (obj instanceof Double) {
      return Double.TYPE;
    }
    if (obj instanceof Character) {
      return Character.TYPE;
    }
    throw new IllegalArgumentException("Not found type");
  }
}
