/*
 * Copyright 2020 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.seppiko.commons.utils.logging;

import org.seppiko.glf.api.Logger;
import org.seppiko.glf.api.LoggerFactory;

/**
 * Virtual Logger Implement
 *
 * @author Leonard Woo
 */
public class VLoggerImpl implements VLogger{

  private Logger logger;

  public VLoggerImpl(String name) {
    logger = LoggerFactory.getLogger(name);
  }

  @Override
  public void debug(String message) {
    logger.debug(message);
  }

  @Override
  public void debug(String message, Throwable cause) {
    logger.debug(message, cause);
  }

  @Override
  public void info(String message) {
    logger.info(message);
  }

  @Override
  public void info(String message, Throwable cause) {
    logger.info(message, cause);
  }

  @Override
  public void warn(String message) {
    logger.warn(message);
  }

  @Override
  public void warn(String message, Throwable cause) {
    logger.warn(message, cause);
  }

  @Override
  public void error(String message) {
    logger.error(message);
  }

  @Override
  public void error(String message, Throwable cause) {
    logger.error(message, cause);
  }
}
