/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionUtil {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static <T> T newInstance(Class<T> clazz) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static <T> T newInstance(Class<T> clazz, Class<?>[] parameterTypes, Object[] initargs) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return clazz.getDeclaredConstructor(parameterTypes).newInstance(initargs);
    }

    public static <T> Method findMethod(Class<T> clazz, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        return clazz.getDeclaredMethod(methodName, parameterTypes);
    }

    public static <T> Method findMethod(Class<T> clazz, String methodName) throws NoSuchMethodException, SecurityException {
        return ReflectionUtil.findMethod(clazz, methodName, EMPTY_CLASS_ARRAY);
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) throws InvocationTargetException, IllegalAccessException, IllegalArgumentException {
        return method.invoke(target, args);
    }

    public static Object invokeMethod(Method method, Object target) throws InvocationTargetException, IllegalAccessException, IllegalArgumentException {
        return ReflectionUtil.invokeMethod(method, target, EMPTY_OBJECT_ARRAY);
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        Method[] declaredMethods = clazz.getDeclaredMethods();
        return declaredMethods.length == 0 ? declaredMethods : (Method[])declaredMethods.clone();
    }

    public static <T> T getField(Field field, T target) throws IllegalArgumentException, IllegalAccessException {
        return (T)field.get(target);
    }

    public static <T> void setField(Field field, T target, T value) throws IllegalArgumentException, IllegalAccessException {
        field.set(target, value);
    }
}

