/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Objects;

public class StreamUtil {
    public static InputStream findFile(Class<?> clazz, String path) throws FileNotFoundException {
        try {
            ClassLoader cl = clazz.getClassLoader();
            InputStream is = cl.getResourceAsStream(path);
            if (is == null) {
                try {
                    is = new FileInputStream(Objects.requireNonNull(cl.getResource(path)).getPath());
                }
                catch (NullPointerException ex) {
                    is = null;
                }
            }
            if (is == null) {
                is = new FileInputStream(path);
            }
            return is;
        }
        catch (IOException ex) {
            throw new FileNotFoundException();
        }
    }

    public static InputStream getStream(String filepath) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(filepath));
    }

    public static InputStream getStream(File file) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(file));
    }

    public static BufferedReader loadString(String str) {
        return new BufferedReader(new StringReader(str));
    }

    public static BufferedReader loadReader(InputStream is) {
        return new BufferedReader(new InputStreamReader(is));
    }

    public static BufferedReader loadReader(InputStream is, Charset charset) {
        return new BufferedReader(new InputStreamReader(is, charset));
    }

    public static String readerToString(BufferedReader reader) throws IOException {
        StringBuffer sb = new StringBuffer();
        while (reader.ready()) {
            sb.append(reader.readLine());
        }
        return sb.toString();
    }

    public static Writer writeFile(String pathname) throws IOException {
        return StreamUtil.writeFile(new File(pathname));
    }

    public static Writer writeFile(File file) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        return new FileWriter(file);
    }

    public static void toFile(byte[] b, File file) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        ((OutputStream)os).write(b);
        ((OutputStream)os).close();
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        is.transferTo(os);
        os.flush();
    }
}

