/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.nio.charset.Charset;
import org.seppiko.commons.utils.ObjectUtil;

public class StringUtil {
    private static final char[] LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String safeNull(String src, String defaultValue) {
        return ObjectUtil.safeNull(src, defaultValue);
    }

    public static boolean isEmpty(String str) {
        return str == null || "".equals(str);
    }

    public static boolean hasLength(String str) {
        return str != null && !str.isEmpty();
    }

    public static boolean hasText(CharSequence str) {
        return str != null && str.length() > 0 && StringUtil.containsText(str);
    }

    public static boolean hasText(String str) {
        return StringUtil.hasText(str);
    }

    public static String transcoding(String data, Charset oldEncoding, Charset newEncoding) {
        return newEncoding.decode(oldEncoding.encode(data)).toString();
    }

    private static boolean containsText(CharSequence str) {
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String fixedLength(String str, int length, char preChar) {
        StringBuffer sb = new StringBuffer();
        if (str.length() < length) {
            int preLength = length - str.length();
            for (int i = 0; i < preLength; ++i) {
                sb.append(preChar);
            }
            sb.append(str);
        } else {
            sb.append(str.substring(str.length() - length));
        }
        return sb.toString();
    }

    public static char[] encodeHexWithInteger(byte[] data) {
        char[] hexs = new char[data.length * 2];
        int i = 0;
        int j = 0;
        while (i < data.length) {
            char[] hex = Integer.toHexString(data[i] & 0xFF).toCharArray();
            hexs[j] = hex.length == 1 ? 48 : hex[0];
            hexs[j + 1] = hex.length == 1 ? hex[0] : hex[1];
            ++i;
            j += 2;
        }
        return hexs;
    }

    public static String encodeHexToString(byte[] data) {
        return StringUtil.hexToString(StringUtil.encodeHex(data), 2, " ");
    }

    public static char[] encodeHex(byte[] data) {
        return StringUtil.encodeHex(data, true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return StringUtil.encodeHex(data, toLowerCase ? LOWER : UPPER);
    }

    private static String hexToString(char[] chars, int splitNum, String split) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < chars.length; i += splitNum) {
            for (int j = 0; j < splitNum; ++j) {
                sb.append(chars[i + j]);
            }
            sb.append(split);
        }
        String dst = sb.toString();
        return dst.substring(0, dst.length() - split.length());
    }

    private static char[] encodeHex(byte[] data, char[] hexChar) {
        char[] hex = new char[data.length * 2];
        int i = 0;
        int j = 0;
        while (i < data.length) {
            hex[j] = hexChar[(0xF0 & data[i]) >>> 4];
            hex[j + 1] = hexChar[0xF & data[i]];
            ++i;
            j += 2;
        }
        return hex;
    }

    public static byte[] decodeHex(char[] data) {
        byte[] hex = new byte[data.length / 2];
        int i = 0;
        int j = 0;
        while (i < hex.length) {
            int f = StringUtil.toDigit(data[j]) << 4;
            hex[i] = (byte)((f |= StringUtil.toDigit(data[j + 1])) & 0xFF);
            ++i;
            j += 2;
        }
        return hex;
    }

    private static int toDigit(char hexChar) {
        int digit = Character.digit(hexChar, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Invalid Hexadecimal Character: " + hexChar);
        }
        return digit;
    }
}

