/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.logging;

import java.lang.reflect.InvocationTargetException;
import org.seppiko.commons.utils.ReflectionUtil;
import org.seppiko.commons.utils.logging.VLogger;
import org.seppiko.commons.utils.logging.VLoggerImpl;

public class VLoggerManager {
    private static VLoggerManager INSTANCE = new VLoggerManager();
    private String clazzName = VLoggerImpl.class.getName();

    public static VLoggerManager getInstance() {
        return INSTANCE;
    }

    private VLoggerManager() {
    }

    public VLoggerManager setClazzName(String clazzName) {
        this.clazzName = clazzName;
        return this;
    }

    public VLogger getLogger(String name) {
        try {
            Class<?> clazz = Class.forName(this.clazzName);
            return (VLogger)ReflectionUtil.newInstance(clazz, new Class[]{String.class}, new String[]{name});
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            System.err.println("Injection failed");
            System.err.println(ex);
            throw new IllegalArgumentException("Injection failed");
        }
    }

    public VLogger getLogger(Class<?> clazz) {
        return this.getLogger(clazz.getName());
    }
}

