/*
 * Copyright 2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.seppiko.commons.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;

/**
 * @author Leonard Woo
 */
public abstract class CommonPreparedStatement extends CommonStatement implements PreparedStatement {

  @Override
  public void setByte(int parameterIndex, byte x) throws SQLException {
    setBytes(parameterIndex, new byte[]{x});
  }

  @Override
  public void setDate(int parameterIndex, Date x) throws SQLException {
    setDate(parameterIndex, x, null);
  }

  @Override
  public void setTime(int parameterIndex, Time x) throws SQLException {
    setTime(parameterIndex, x, null);
  }

  @Override
  public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
    setTimestamp(parameterIndex, x, null);
  }

  @Override
  public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
    setObject(parameterIndex, x, targetSqlType, -1);
  }

  @Override
  public void setObject(int parameterIndex, Object x) throws SQLException {
    setObject(parameterIndex, x, -1);
  }

  @Override
  public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
    throw ExceptionFactory.notSupport("SQLXML type is not supported");
  }

  @Override
  public void setRef(int parameterIndex, Ref x) throws SQLException {
    throw ExceptionFactory.notSupport("REF parameter are not supported");
  }

  @Override
  public void setClob(int parameterIndex, Reader reader) throws SQLException {
    setClob(parameterIndex, reader, -1);
  }

  @Override
  public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
    setBlob(parameterIndex, inputStream, -1);
  }

  @Override
  public void setNClob(int parameterIndex, Reader reader) throws SQLException {
    setNClob(parameterIndex, reader, -1);
  }

  @Override
  public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
    setAsciiStream(parameterIndex, x, -1);
  }

  @Override
  public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
    setAsciiStream(parameterIndex, x, (long) length);
  }

  @Override
  public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
    setBinaryStream(parameterIndex, x, -1);
  }

  @Override
  public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
    setBinaryStream(parameterIndex, x, (long) length);
  }

  @Override
  public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
    setCharacterStream(parameterIndex, reader, -1);
  }

  @Override
  public void setCharacterStream(int parameterIndex, Reader reader, int length)
      throws SQLException {
    setCharacterStream(parameterIndex, reader, (long) length);
  }

  @Override
  public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
    setNCharacterStream(parameterIndex, value, -1);
  }

}
