/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import org.seppiko.commons.jdbc.CommonStatement;
import org.seppiko.commons.jdbc.ExceptionFactory;

public abstract class CommonPreparedStatement
extends CommonStatement
implements PreparedStatement {
    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setBytes(parameterIndex, new byte[]{x});
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, null);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, null);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, null);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, -1);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.setObject(parameterIndex, x, -1);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw ExceptionFactory.notSupport("SQLXML type is not supported");
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw ExceptionFactory.notSupport("REF parameter are not supported");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.setClob(parameterIndex, reader, -1L);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setBlob(parameterIndex, inputStream, -1L);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.setNClob(parameterIndex, reader, -1L);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setAsciiStream(parameterIndex, x, -1);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setAsciiStream(parameterIndex, x, (long)length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.setBinaryStream(parameterIndex, x, -1);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, (long)length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, -1);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, (long)length);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setNCharacterStream(parameterIndex, value, -1L);
    }
}

