/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.jdbc;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientConnectionException;

public class ExceptionFactory {
    public static SQLException syntaxError(String message) {
        return new ExceptionFactory().create(message, ErrCode.SyntaxError);
    }

    public static SQLException notSupport(String message) {
        return new ExceptionFactory().create(message, ErrCode.FeatureNotSupported);
    }

    public static SQLException timeout(String message) {
        return new ExceptionFactory().create(message, ErrCode.Timeout);
    }

    private SQLException create(String message, ErrCode errorCode) {
        return this.createException(message, null, errorCode, null);
    }

    private SQLException create(String message, String sqlState, ErrCode errorCode) {
        return this.createException(message, sqlState, errorCode, null);
    }

    private SQLException create(String message, ErrCode errorCode, Exception cause) {
        return this.createException(message, null, errorCode, cause);
    }

    private SQLException createException(String message, String sqlState, ErrCode errorCode, Exception cause) {
        switch (errorCode) {
            case FeatureNotSupported: {
                return new SQLFeatureNotSupportedException(message, sqlState, cause);
            }
            case SyntaxError: {
                return new SQLSyntaxErrorException(message, sqlState, cause);
            }
            case InvalidAuthorizationSpec: {
                return new SQLInvalidAuthorizationSpecException(message, sqlState, cause);
            }
            case IntegrityConstraintViolation: {
                return new SQLIntegrityConstraintViolationException(message, sqlState, cause);
            }
            case NonTransientConnection: {
                return new SQLNonTransientConnectionException(message, sqlState, cause);
            }
            case TransientConnection: {
                return new SQLTransientConnectionException(message, sqlState, cause);
            }
            case TransactionRollback: {
                return new SQLTransactionRollbackException(message, sqlState, cause);
            }
            case Timeout: {
                return new SQLTimeoutException(message, sqlState, cause);
            }
        }
        return new SQLException(message, sqlState, cause);
    }

    public static enum ErrCode {
        FeatureNotSupported(1),
        SyntaxError(2),
        InvalidAuthorizationSpec(3),
        IntegrityConstraintViolation(4),
        NonTransientConnection(5),
        TransientConnection(6),
        TransactionRollback(7),
        Timeout(8);

        final int code;

        private ErrCode(int code) {
            this.code = code;
        }
    }
}

