/*
 * Copyright 2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.seppiko.commons.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;

/**
 * @author Leonard Woo
 */
public interface CommonResultSetMetaData extends ResultSetMetaData {

  @Override
  default boolean isCaseSensitive(int column) throws SQLException {
    return true;
  }

  @Override
  default boolean isSearchable(int column) throws SQLException {
    return true;
  }

  @Override
  default boolean isCurrency(int column) throws SQLException {
    return true;
  }

  @Override
  default <T> T unwrap(Class<T> iface) throws SQLException {
    if (isWrapperFor(iface)) {
      return iface.cast(this);
    }
    throw new SQLException("The receiver is not a wrapper for " + iface.getName());
  }

  @Override
  default boolean isWrapperFor(Class<?> iface) throws SQLException {
    if (iface == null) {
      return false;
    }
    return iface.isInstance(this);
  }
}
