/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.RowIdLifetime;
import java.sql.SQLException;

public interface CommonDatabaseMetaData
extends DatabaseMetaData {
    @Override
    default public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    default public int getJDBCMajorVersion() throws SQLException {
        return 4;
    }

    @Override
    default public int getJDBCMinorVersion() throws SQLException {
        return 3;
    }

    @Override
    default public String getDriverVersion() throws SQLException {
        return this.getDriverMajorVersion() + "." + this.getDriverMinorVersion();
    }

    @Override
    default public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    default public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    default public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return true;
    }

    @Override
    default public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    default public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    @Override
    default public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    default public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    default public int getMaxBinaryLiteralLength() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    default public int getMaxCharLiteralLength() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    default public int getMaxColumnsInSelect() throws SQLException {
        return Short.MAX_VALUE;
    }

    @Override
    default public int getDefaultTransactionIsolation() throws SQLException {
        return 4;
    }

    @Override
    default public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return this.supportsMixedCaseIdentifiers();
    }

    @Override
    default public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return this.storesUpperCaseIdentifiers();
    }

    @Override
    default public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return this.storesLowerCaseIdentifiers();
    }

    @Override
    default public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return this.storesMixedCaseIdentifiers();
    }

    @Override
    default public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    default public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    default public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    default public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    @Override
    default public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    default public boolean nullsAreSortedAtEnd() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsConvert() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsConvert(int fromType, int toType) throws SQLException {
        switch (fromType) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                switch (toType) {
                    case -7: 
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 16: {
                        return true;
                    }
                }
                return false;
            }
            case 2004: {
                switch (toType) {
                    case -7: 
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 16: {
                        return true;
                    }
                }
                return false;
            }
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                switch (toType) {
                    case -16: 
                    case -15: 
                    case -7: 
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 16: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 2004: 
                    case 2005: 
                    case 2011: {
                        return true;
                    }
                }
                return false;
            }
            case 91: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: {
                        return true;
                    }
                }
                return false;
            }
            case 92: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 92: {
                        return true;
                    }
                }
                return false;
            }
            case 93: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    @Override
    default public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsANSI92FullSQL() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    default public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    default public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    default public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    default public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    default public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    default public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    default public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        switch (level) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    default public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    default public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1004 || type == 1003;
    }

    @Override
    default public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return type == 1004 || type == 1003;
    }

    @Override
    default public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return this.supportsResultSetType(type);
    }

    @Override
    default public boolean ownDeletesAreVisible(int type) throws SQLException {
        return this.supportsResultSetType(type);
    }

    @Override
    default public boolean ownInsertsAreVisible(int type) throws SQLException {
        return this.supportsResultSetType(type);
    }

    @Override
    default public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    default public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    @Override
    default public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    default public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return holdability == 1;
    }

    @Override
    default public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    default public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return true;
    }

    @Override
    default public boolean supportsRefCursors() throws SQLException {
        return false;
    }

    @Override
    default public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw new SQLException("The receiver is not a wrapper for " + iface.getName());
    }

    @Override
    default public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface == null) {
            return false;
        }
        return iface.isInstance(this);
    }

    @Override
    default public long getMaxLogicalLobSize() throws SQLException {
        return Integer.toUnsignedLong(-1);
    }
}

