/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.jdbc;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientConnectionException;

public class ExceptionFactory {
    public static SQLException syntaxError(String message) {
        return new ExceptionFactory().create(message, "42000");
    }

    public static SQLException notSupport(String message) {
        return new ExceptionFactory().create(message, "0A000");
    }

    public static SQLException timeout(String message) {
        return new ExceptionFactory().create(message, "ZZ000");
    }

    public static SQLException unknown(String message) {
        return new ExceptionFactory().create(message);
    }

    private SQLException create(String message) {
        return this.createException(message, "HY100", -1, null);
    }

    private SQLException create(String message, String sqlState) {
        return this.createException(message, sqlState, -1, null);
    }

    private SQLException create(String message, String sqlState, int errorCode) {
        return this.createException(message, sqlState, errorCode, null);
    }

    private SQLException create(String message, String sqlState, Exception cause) {
        return this.createException(message, sqlState, -1, cause);
    }

    private SQLException createException(String message, String sqlState, int errorCode, Exception cause) {
        String subClazz;
        switch (subClazz = sqlState == null ? "42" : sqlState.substring(0, 2)) {
            case "0A": {
                return new SQLFeatureNotSupportedException(message, sqlState, errorCode, cause);
            }
            case "42": {
                return new SQLSyntaxErrorException(message, sqlState, errorCode, cause);
            }
            case "28": {
                return new SQLInvalidAuthorizationSpecException(message, sqlState, errorCode, cause);
            }
            case "23": {
                return new SQLIntegrityConstraintViolationException(message, sqlState, errorCode, cause);
            }
            case "08": {
                return new SQLNonTransientConnectionException(message, sqlState, errorCode, cause);
            }
            case "TC": {
                return new SQLTransientConnectionException(message, sqlState, errorCode, cause);
            }
            case "40": {
                return new SQLTransactionRollbackException(message, sqlState, errorCode, cause);
            }
            case "HY": {
                return new SQLException(message, sqlState, errorCode, cause);
            }
        }
        return new SQLTimeoutException(message, sqlState, errorCode, cause);
    }
}

