/*
 * Copyright 2020 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.seppiko.commons.logging;

/**
 * @author Leonard Woo
 */
public class Report {

  public static void submitException(boolean expression, String message) {
    if (expression) {
      throw new IllegalArgumentException(message);
    }
  }

  public static void submitPrint(boolean expression, Object message) {
    if (expression) {
      System.err.println(message);
    }
  }

  public static void submitPrint(Object message) {
    System.err.println(message);
  }
}
