/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.logging;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.seppiko.commons.logging.AbstractLogging;
import org.seppiko.commons.logging.AbstractLoggingServiceProvider;
import org.seppiko.commons.logging.Report;

public class AbstractLoggingManager {
    private static AbstractLoggingManager INSTANCE = new AbstractLoggingManager();
    private String clazzName;

    public static AbstractLoggingManager getInstance() {
        return INSTANCE;
    }

    private AbstractLoggingManager() {
        this.init();
    }

    private void init() {
        List<AbstractLoggingServiceProvider> providers = this.findAbstractLoggingServiceProviders();
        Report.submitException(providers.size() > 1, "Class path contains multiple providers.");
        if (!providers.isEmpty()) {
            this.clazzName = providers.get(0).getAbstractLoggingName();
            Report.submitException(providers.size() > 1, "Actual provider is of type [" + providers.get(0) + "]");
        } else {
            Report.submitPrint("No AbsLogProviders were found.");
            Report.submitPrint("Default implement with GLF");
        }
    }

    private List<AbstractLoggingServiceProvider> findAbstractLoggingServiceProviders() {
        ServiceLoader<AbstractLoggingServiceProvider> loader = ServiceLoader.load(AbstractLoggingServiceProvider.class);
        ArrayList<AbstractLoggingServiceProvider> providers = new ArrayList<AbstractLoggingServiceProvider>();
        loader.forEach(providers::add);
        return providers;
    }

    public AbstractLogging getLogger(String name) {
        try {
            return (AbstractLogging)Class.forName(this.clazzName).getDeclaredConstructor(String.class).newInstance(name);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            Report.submitPrint("Injection failed");
            Report.submitPrint(ex);
            throw new IllegalArgumentException("Injection failed");
        }
    }

    public AbstractLogging getLogger(Class<?> clazz) {
        return this.getLogger(clazz.getName());
    }
}

