/*
 * Copyright 2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.seppiko.commons.logging;

/**
 * Abstract Logging interface
 *
 * @author Leonard Woo
 */
public interface AbstractLogging {

  /**
   * Checks whether this Logger is enabled for the TRACE level.
   *
   * @return true if this Logger is enabled for level TRACE, false otherwise.
   */
  boolean isTraceEnable();

  /**
   * Logs a message CharSequence with the TRACE level.
   *
   * @param message the message object to log.
   */
  void trace(CharSequence message);

  /**
   * Logs a CharSequence at the TRACE level including the stack trace of the Throwable. throwable passed as parameter.
   *
   * @param message the message object to log.
   * @param cause the Throwable to log, including its stack trace.
   */
  void trace(CharSequence message, Throwable cause);

  /**
   * Checks whether this Logger is enabled for the DEBUG level.
   *
   * @return true if this Logger is enabled for level DEBUG, false otherwise.
   */
  boolean isDebugEnable();

  /**
   * Logs a message CharSequence with the DEBUG level.
   *
   * @param message the message object to log.
   */
  void debug(CharSequence message);

  /**
   * Logs a CharSequence at the DEBUG level including the stack trace of the Throwable. throwable passed as parameter.
   *
   * @param message the message object to log.
   * @param cause the Throwable to log, including its stack trace.
   */
  void debug(CharSequence message, Throwable cause);

  /**
   * Checks whether this Logger is enabled for the INFO level.
   *
   * @return true if this Logger is enabled for level INFO, false otherwise.
   */
  boolean isInfoEnable();

  /**
   * Logs a message CharSequence with the INFO level.
   *
   * @param message the message object to log.
   */
  void info(CharSequence message);

  /**
   * Logs a CharSequence at the INFO level including the stack trace of the Throwable. throwable passed as parameter.
   *
   * @param message the message object to log.
   * @param cause the Throwable to log, including its stack trace.
   */
  void info(CharSequence message, Throwable cause);

  /**
   * Checks whether this Logger is enabled for the WARN level.
   *
   * @return true if this Logger is enabled for level WARN, false otherwise.
   */
  boolean isWarnEnable();

  /**
   * Logs a message CharSequence with the WARN level.
   *
   * @param message the message object to log.
   */
  void warn(CharSequence message);

  /**
   * Logs a CharSequence at the WARN level including the stack trace of the Throwable. throwable passed as parameter.
   *
   * @param message the message object to log.
   * @param cause the Throwable to log, including its stack trace.
   */
  void warn(CharSequence message, Throwable cause);

  /**
   * Checks whether this Logger is enabled for the ERROR level.
   *
   * @return true if this Logger is enabled for level ERROR, false otherwise.
   */
  boolean isErrorEnable();

  /**
   * Logs a message CharSequence with the ERROR level.
   *
   * @param message the message object to log.
   */
  void error(CharSequence message);

  /**
   * Logs a CharSequence at the ERROR level including the stack trace of the Throwable. throwable passed as parameter.
   *
   * @param message the message object to log.
   * @param cause the Throwable to log, including its stack trace.
   */
  void error(CharSequence message, Throwable cause);

  /**
   * Checks whether this Logger is enabled for the FATAL level.
   *
   * @return true if this Logger is enabled for level FATAL, false otherwise.
   */
  boolean isFatalEnable();

  /**
   * Logs a message CharSequence with the FATAL level.
   *
   * @param message the message object to log.
   */
  void fatal(CharSequence message);

  /**
   * Logs a CharSequence at the FATAL level including the stack trace of the Throwable. throwable passed as parameter.
   *
   * @param message the message object to log.
   * @param cause the Throwable to log, including its stack trace.
   */
  void fatal(CharSequence message, Throwable cause);

}
