/*
 * Copyright 2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.seppiko.commons.logging;

import java.util.function.Supplier;

/**
 * Logging builder interface
 *
 * @author Leonard Woo
 */
public interface ILoggingBuilder {

  /**
   * Level TRACE
   *
   * @return this object
   */
  ILoggingBuilder atTrace();

  /**
   * Level DEBUG
   *
   * @return this object
   */
  ILoggingBuilder atDebug();

  /**
   * Level INFO
   *
   * @return this object
   */
  ILoggingBuilder atInfo();

  /**
   * Level WARN
   *
   * @return this object
   */
  ILoggingBuilder atWarn();

  /**
   * Level ERROR
   *
   * @return this object
   */
  ILoggingBuilder atError();

  /**
   * Level FATAL
   *
   * @return this object
   */
  ILoggingBuilder atFatal();

  /**
   * Set message
   *
   * @param message message
   * @return this object
   */
  ILoggingBuilder message(CharSequence message);

  /**
   * Set throwable
   *
   * @param cause throwable
   * @return this object
   */
  ILoggingBuilder withCause(Throwable cause);

  /**
   * Set object parameter
   *
   * @param paramSupplier parameter
   * @return this object
   */
  ILoggingBuilder param(Supplier<?> paramSupplier);

  /**
   * Logging builder
   */
  void log();

}
