/*
 * Copyright 2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.seppiko.commons.logging;

import java.util.function.Supplier;

/**
 * Logging Extended interface
 *
 * @author Leonard Woo
 */
public interface ILoggingExtended {

  /**
   * Checks whether this Logger is enabled for the given Level.
   *
   * @param level the Level to check
   * @return boolean - {@code true} if this Logger is enabled for level, {@code false} otherwise.
   */
  boolean isEnable(int level);

  /**
   * Logs a message with the specific Marker at the given level.
   *
   * @param level the logging level
   * @param message the message string to be logged
   */
  void log(int level, CharSequence message);

  /**
   * Logs a message with the specific Marker at the given level.
   *
   * @param level the logging level
   * @param message the message string to be logged
   * @param cause A Throwable or null
   */
  void log(int level, CharSequence message, Throwable cause);

  /**
   * Logs a message with the specific Marker at the given level.
   *
   * @param level the logging level
   * @param message the message string to be logged
   * @param cause a Throwable or null
   * @param paramSuppliers the parameter objects or null to be logged
   */
  void log(int level, CharSequence message, Throwable cause, Supplier<?>... paramSuppliers);

}
