/*
 * Copyright 2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.seppiko.commons.logging.utils;

import java.io.PrintStream;

/**
 * Log report and print out
 *
 * @author Leonard Woo
 */
public class Report {

  private static final PrintStream print;

  static {
    print = System.out;
  }

  /**
   * print diagnostic
   *
   * @param message diagnostic message.
   */
  public static void diagno(String message) {
    print.println(message);
    print.flush();
  }

  /**
   * print diagnostic
   *
   * @param message diagnostic message.
   * @param cause diagnostic Throwable.
   */
  public static void diagno(String message, Throwable cause) {
    print.println(message);
    print.flush();
    if (cause != null) {
      cause.printStackTrace(print);
    }
  }
}
