/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.logging.event;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.seppiko.commons.logging.Logging;
import org.seppiko.commons.logging.LoggingBuilder;
import org.seppiko.commons.logging.event.DefaultLoggingBuilder;
import org.seppiko.commons.logging.utils.Report;

public class DefaultLogging
implements Logging {
    protected static final String DEFAULT_DATE_TIME_FORMAT = "yyyy/MM/dd HH:mm:ss:SSS zzz";
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss:SSS zzz");
    protected volatile int currentLogLevel;
    private volatile String loggingName;

    public DefaultLogging() {
    }

    public DefaultLogging(String loggingName) {
        this.loggingName = loggingName;
    }

    public void setDelegate(Logging logging) {
        this.loggingName = logging.getName();
    }

    @Override
    public String getName() {
        return this.loggingName;
    }

    @Override
    public boolean isEnable(int level) {
        return level >= this.currentLogLevel;
    }

    @Override
    public void log(int level, CharSequence message) {
        this.log(level, message, null);
    }

    @Override
    public void log(int level, CharSequence message, Throwable cause) {
        this.log(level, message, cause, new Supplier[]{null});
    }

    @Override
    public void log(int level, CharSequence message, Throwable cause, Supplier<?> ... paramSuppliers) {
        List<Supplier> list = Arrays.stream(paramSuppliers).filter(Objects::nonNull).toList();
        Object[] params = new Object[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            params[i] = list.get(i).get();
        }
        this.log(level, message, cause, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(int level, CharSequence message, Throwable cause, Object ... params) {
        String dateText;
        StringBuffer buf = new StringBuffer();
        ZonedDateTime dateTime = ZonedDateTime.now();
        DateTimeFormatter dateTimeFormatter = dateFormatter;
        synchronized (dateTimeFormatter) {
            dateText = dateTime.format(dateFormatter);
        }
        buf.append(dateText);
        buf.append(" ");
        switch (level) {
            case 10: {
                buf.append("[TRACE] ");
                break;
            }
            case 20: {
                buf.append("[DEBUG] ");
                break;
            }
            case 30: {
                buf.append("[INFO]  ");
                break;
            }
            case 40: {
                buf.append("[WARN]  ");
                break;
            }
            case 50: {
                buf.append("[ERROR] ");
                break;
            }
            case 60: {
                buf.append("[FATAL] ");
            }
        }
        buf.append(this.loggingName);
        buf.append(" - ");
        buf.append(message);
        if (params != null && params.length > 0) {
            buf.append(" <");
            Arrays.stream(params).filter(Objects::nonNull).toList().forEach(obj -> {
                String objStr = obj.toString();
                buf.append(objStr);
                buf.append(", ");
            });
            buf.append(">");
        }
        Report.diagno(buf.toString(), cause);
    }

    @Override
    public boolean isTraceEnable() {
        return this.isEnable(10);
    }

    @Override
    public void trace(CharSequence message) {
        this.log(10, message);
    }

    @Override
    public void trace(CharSequence message, Throwable cause) {
        this.log(10, message, cause);
    }

    @Override
    public void trace(CharSequence message, Throwable cause, Supplier<?> ... paramsSupplier) {
        this.log(10, message, cause, paramsSupplier);
    }

    @Override
    public LoggingBuilder atTrace() {
        return new DefaultLoggingBuilder(this, 10);
    }

    @Override
    public boolean isDebugEnable() {
        return this.isEnable(20);
    }

    @Override
    public void debug(CharSequence message) {
        this.log(20, message);
    }

    @Override
    public void debug(CharSequence message, Throwable cause) {
        this.log(20, message, cause);
    }

    @Override
    public void debug(CharSequence message, Throwable cause, Supplier<?> ... paramsSupplier) {
        this.log(20, message, cause, paramsSupplier);
    }

    @Override
    public LoggingBuilder atDebug() {
        return new DefaultLoggingBuilder(this, 20);
    }

    @Override
    public boolean isInfoEnable() {
        return this.isEnable(30);
    }

    @Override
    public void info(CharSequence message) {
        this.log(30, message);
    }

    @Override
    public void info(CharSequence message, Throwable cause) {
        this.log(30, message, cause);
    }

    @Override
    public void info(CharSequence message, Throwable cause, Supplier<?> ... paramsSupplier) {
        this.log(30, message, cause, paramsSupplier);
    }

    @Override
    public LoggingBuilder atInfo() {
        return new DefaultLoggingBuilder(this, 30);
    }

    @Override
    public boolean isWarnEnable() {
        return this.isEnable(40);
    }

    @Override
    public void warn(CharSequence message) {
        this.log(40, message);
    }

    @Override
    public void warn(CharSequence message, Throwable cause) {
        this.log(40, message, cause);
    }

    @Override
    public void warn(CharSequence message, Throwable cause, Supplier<?> ... paramsSupplier) {
        this.log(40, message, cause, paramsSupplier);
    }

    @Override
    public LoggingBuilder atWarn() {
        return new DefaultLoggingBuilder(this, 40);
    }

    @Override
    public boolean isErrorEnable() {
        return this.isEnable(50);
    }

    @Override
    public void error(CharSequence message) {
        this.log(50, message);
    }

    @Override
    public void error(CharSequence message, Throwable cause) {
        this.log(50, message, cause);
    }

    @Override
    public void error(CharSequence message, Throwable cause, Supplier<?> ... paramsSupplier) {
        this.log(50, message, cause, paramsSupplier);
    }

    @Override
    public LoggingBuilder atError() {
        return new DefaultLoggingBuilder(this, 50);
    }

    @Override
    public boolean isFatalEnable() {
        return this.isEnable(60);
    }

    @Override
    public void fatal(CharSequence message) {
        this.log(60, message);
    }

    @Override
    public void fatal(CharSequence message, Throwable cause) {
        this.log(60, message, cause);
    }

    @Override
    public void fatal(CharSequence message, Throwable cause, Supplier<?> ... paramsSupplier) {
        this.log(60, message, cause, paramsSupplier);
    }

    @Override
    public LoggingBuilder atFatal() {
        return new DefaultLoggingBuilder(this, 60);
    }
}

