/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.logging.event;

import java.util.ArrayList;
import java.util.function.Supplier;
import org.seppiko.commons.logging.Logging;
import org.seppiko.commons.logging.LoggingBuilder;

public class DefaultLoggingBuilder
implements LoggingBuilder {
    private final Logging logging;
    private final int level;
    private CharSequence message;
    private Throwable cause;
    private final ArrayList<Object> params = new ArrayList();

    DefaultLoggingBuilder(Logging logging, int level) {
        this.logging = logging;
        this.level = level;
    }

    @Override
    public LoggingBuilder message(CharSequence message) {
        this.message = message;
        return this;
    }

    @Override
    public LoggingBuilder withCause(Throwable cause) {
        this.cause = cause;
        return this;
    }

    @Override
    public LoggingBuilder param(Supplier<?> paramSupplier) {
        this.params.add(paramSupplier.get());
        return this;
    }

    @Override
    public LoggingBuilder param(Object paramObject) {
        this.params.add(paramObject);
        return this;
    }

    @Override
    public void log() {
        Object[] objects = this.params.toArray(Object[]::new);
        this.logging.log(this.level, this.message, this.cause, objects);
    }
}

