/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.logging.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.seppiko.commons.logging.ILoggingFactory;
import org.seppiko.commons.logging.Logging;
import org.seppiko.commons.logging.event.DefaultLogging;

public class DefaultLoggingFactory
implements ILoggingFactory {
    private final Map<String, DefaultLogging> loggings = new ConcurrentHashMap<String, DefaultLogging>();

    @Override
    public Logging getLogging(String name) {
        DefaultLogging log = this.loggings.get(name);
        if (log == null) {
            log = new DefaultLogging(name);
            this.loggings.put(name, log);
        }
        return log;
    }

    public List<DefaultLogging> getLoggingList() {
        return new ArrayList<DefaultLogging>(this.loggings.values());
    }

    public void clear() {
        this.loggings.clear();
    }
}

