/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.logging;

import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.SecurityPermission;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.seppiko.commons.logging.ILoggingFactory;
import org.seppiko.commons.logging.Logging;
import org.seppiko.commons.logging.event.DefaultLogging;
import org.seppiko.commons.logging.event.DefaultLoggingServiceProvider;
import org.seppiko.commons.logging.spi.LoggingServiceProvider;
import org.seppiko.commons.logging.utils.Report;

public class LoggingFactory {
    private static final DefaultLoggingServiceProvider DEFAULT_PROVIDER = new DefaultLoggingServiceProvider();
    static volatile LoggingServiceProvider PROVIDER;

    protected LoggingFactory() {
    }

    public static Logging getLogging(String name) {
        return LoggingFactory.getILoggingFactory().getLogging(name);
    }

    public static Logging getLogging(Class<?> clazz) {
        return LoggingFactory.getLogging(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static ILoggingFactory getILoggingFactory() {
        if (PROVIDER == null) {
            Class<LoggingFactory> clazz = LoggingFactory.class;
            // MONITORENTER : org.seppiko.commons.logging.LoggingFactory.class
            if (PROVIDER == null) {
                LoggingFactory.bind();
            }
            // MONITOREXIT : clazz
        }
        if (PROVIDER != null) {
            return PROVIDER.getILoggingFactory();
        }
        Report.diag("[LOOKUP] Not found service provider.");
        return DEFAULT_PROVIDER.getILoggingFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bind() {
        try {
            List<LoggingServiceProvider> providers = LoggingFactory.findServiceProvider(LoggingFactory.class.getClassLoader());
            if (providers.size() > 1) {
                Report.diag("Class path contains multiple service providers.");
                for (LoggingServiceProvider provider : providers) {
                    Report.diag("Found provider [" + String.valueOf(provider) + "]");
                }
            }
            if (!providers.isEmpty()) {
                PROVIDER = providers.get(0);
                PROVIDER.initialize();
                if (providers.size() > 1) {
                    Report.diag("Actual provider is of type [" + String.valueOf(providers.get(0)) + "]");
                }
            }
            DefaultLoggingServiceProvider defaultLoggingServiceProvider = DEFAULT_PROVIDER;
            synchronized (defaultLoggingServiceProvider) {
                for (DefaultLogging defaultLog : DEFAULT_PROVIDER.getLoggingFactory().getLoggingList()) {
                    Logging log = LoggingFactory.getLogging(defaultLog.getName());
                    defaultLog.setDelegate(log);
                }
            }
            DEFAULT_PROVIDER.getLoggingFactory().clear();
        }
        catch (Exception e) {
            PROVIDER = null;
            Report.diag("Failed to instantiate LoggingFactory", e);
            throw new IllegalStateException("Unexpected initialization failure", e);
        }
    }

    private static List<LoggingServiceProvider> findServiceProvider(ClassLoader classLoader) {
        ArrayList<LoggingServiceProvider> providers = new ArrayList<LoggingServiceProvider>();
        ServiceLoader<LoggingServiceProvider> loader = LoggingFactory.getServiceLoader(classLoader);
        loader.forEach(providers::add);
        return providers;
    }

    private static ServiceLoader<LoggingServiceProvider> getServiceLoader(ClassLoader classLoader) {
        ServiceLoader serviceLoader;
        PermissionCollection permissionCollection = new SecurityPermission("insertProvider").newPermissionCollection();
        if (permissionCollection == null) {
            serviceLoader = ServiceLoader.load(LoggingServiceProvider.class, classLoader);
        } else {
            PrivilegedAction<ServiceLoader> action = () -> ServiceLoader.load(LoggingServiceProvider.class, classLoader);
            serviceLoader = action.run();
        }
        return serviceLoader;
    }
}

