/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.logging.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.seppiko.commons.logging.ILoggingFactory;
import org.seppiko.commons.logging.Logging;
import org.seppiko.commons.logging.event.DefaultLogging;

public class DefaultLoggingFactory
implements ILoggingFactory {
    private final Map<String, DefaultLogging> loggingMap = new ConcurrentHashMap<String, DefaultLogging>();

    @Override
    public Logging getLogging(String name) {
        DefaultLogging log = this.loggingMap.get(name);
        if (log == null) {
            log = new DefaultLogging(name);
            this.loggingMap.put(name, log);
        }
        return log;
    }

    public List<DefaultLogging> getLoggingList() {
        return new ArrayList<DefaultLogging>(this.loggingMap.values());
    }

    public void clear() {
        this.loggingMap.clear();
    }
}

