/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.logging.event;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Supplier;
import org.seppiko.commons.logging.Logging;
import org.seppiko.commons.logging.LoggingBuilder;
import org.seppiko.commons.logging.event.DefaultLoggingBuilder;
import org.seppiko.commons.logging.utils.Report;
import org.seppiko.commons.logging.utils.Utils;

public class DefaultLogging
implements Logging {
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ISO_INSTANT;
    protected volatile int currentLogLevel;
    private volatile String name;

    private DefaultLogging() {
    }

    public DefaultLogging(String name) {
        this.name = name;
    }

    public void setDelegate(Logging logging) {
        this.name = logging.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEnable(int level) {
        return level >= this.currentLogLevel;
    }

    @Override
    public void log(int level, CharSequence message) {
        this.log(level, message, Utils.NON_CAUSE);
    }

    @Override
    public void log(int level, CharSequence message, Throwable cause) {
        this.log(level, message, cause, Utils.NULL_SUPPLIERS);
    }

    @Override
    public void log(int level, CharSequence message, Supplier<?> ... paramSuppliers) {
        this.log(level, message, Utils.NON_CAUSE, paramSuppliers);
    }

    @Override
    public void log(int level, CharSequence message, Object ... params) {
        this.log(level, message, Utils.NON_CAUSE, params);
    }

    @Override
    public void log(int level, CharSequence message, Throwable cause, Supplier<?> ... paramSuppliers) {
        Object[] params = Utils.NULL_OBJECTS;
        if (paramSuppliers != null && paramSuppliers.length > 0) {
            params = Utils.getSuppliers(paramSuppliers);
        }
        this.log(level, message, cause, params);
    }

    @Override
    public void log(int level, CharSequence message, Throwable cause, Object ... params) {
        StringBuilder builder = new StringBuilder();
        ZonedDateTime dateTime = ZonedDateTime.now();
        builder.append(dateTime.format(dateFormatter));
        builder.append(" ");
        switch (level) {
            case 10: {
                builder.append("[TRACE] ");
                break;
            }
            case 20: {
                builder.append("[DEBUG] ");
                break;
            }
            case 30: {
                builder.append("[INFO]  ");
                break;
            }
            case 40: {
                builder.append("[WARN]  ");
                break;
            }
            case 50: {
                builder.append("[ERROR] ");
                break;
            }
            case 60: {
                builder.append("[FATAL] ");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected level value: " + level);
            }
        }
        builder.append(this.name);
        builder.append(" - ");
        builder.append(message);
        builder.append(" ");
        if (params != null && params.length > 0) {
            StringJoiner objJoiner = new StringJoiner(", ");
            Arrays.stream(params).filter(Objects::nonNull).forEach(obj -> objJoiner.add(obj.toString()));
            builder.append("<");
            builder.append(objJoiner);
            builder.append(">");
        }
        Report.print(builder.toString(), cause);
    }

    @Override
    public boolean isTraceEnable() {
        return this.isEnable(10);
    }

    @Override
    public void trace(CharSequence message) {
        this.log(10, message);
    }

    @Override
    public void trace(CharSequence message, Throwable cause) {
        this.log(10, message, cause, Utils.NULL_OBJECTS);
    }

    @Override
    public void trace(CharSequence message, Object ... params) {
        this.log(10, message, Utils.NON_CAUSE, params);
    }

    @Override
    public void trace(CharSequence message, Supplier<?> ... paramsSupplier) {
        this.log(10, message, Utils.NON_CAUSE, paramsSupplier);
    }

    @Override
    public void trace(CharSequence message, Throwable cause, Supplier<?> ... paramsSupplier) {
        this.log(10, message, cause, paramsSupplier);
    }

    @Override
    public void trace(CharSequence message, Throwable cause, Object ... params) {
        this.log(10, message, cause, params);
    }

    @Override
    public LoggingBuilder atTrace() {
        return new DefaultLoggingBuilder(this, 10);
    }

    @Override
    public boolean isDebugEnable() {
        return this.isEnable(20);
    }

    @Override
    public void debug(CharSequence message) {
        this.log(20, message);
    }

    @Override
    public void debug(CharSequence message, Throwable cause) {
        this.log(20, message, cause);
    }

    @Override
    public void debug(CharSequence message, Object ... params) {
        this.log(20, message, params);
    }

    @Override
    public void debug(CharSequence message, Supplier<?> ... paramsSupplier) {
        this.log(20, message, paramsSupplier);
    }

    @Override
    public void debug(CharSequence message, Throwable cause, Supplier<?> ... paramsSupplier) {
        this.log(20, message, cause, paramsSupplier);
    }

    @Override
    public void debug(CharSequence message, Throwable cause, Object ... params) {
        this.log(20, message, cause, params);
    }

    @Override
    public LoggingBuilder atDebug() {
        return new DefaultLoggingBuilder(this, 20);
    }

    @Override
    public boolean isInfoEnable() {
        return this.isEnable(30);
    }

    @Override
    public void info(CharSequence message) {
        this.log(30, message);
    }

    @Override
    public void info(CharSequence message, Throwable cause) {
        this.log(30, message, cause);
    }

    @Override
    public void info(CharSequence message, Object ... params) {
        this.log(30, message, params);
    }

    @Override
    public void info(CharSequence message, Supplier<?> ... paramsSupplier) {
        this.log(30, message, paramsSupplier);
    }

    @Override
    public void info(CharSequence message, Throwable cause, Supplier<?> ... paramsSupplier) {
        this.log(30, message, cause, paramsSupplier);
    }

    @Override
    public void info(CharSequence message, Throwable cause, Object ... params) {
        this.log(30, message, cause, params);
    }

    @Override
    public LoggingBuilder atInfo() {
        return new DefaultLoggingBuilder(this, 30);
    }

    @Override
    public boolean isWarnEnable() {
        return this.isEnable(40);
    }

    @Override
    public void warn(CharSequence message) {
        this.log(40, message);
    }

    @Override
    public void warn(CharSequence message, Throwable cause) {
        this.log(40, message, cause);
    }

    @Override
    public void warn(CharSequence message, Object ... params) {
        this.log(40, message, params);
    }

    @Override
    public void warn(CharSequence message, Supplier<?> ... paramsSupplier) {
        this.log(40, message, paramsSupplier);
    }

    @Override
    public void warn(CharSequence message, Throwable cause, Supplier<?> ... paramsSupplier) {
        this.log(40, message, cause, paramsSupplier);
    }

    @Override
    public void warn(CharSequence message, Throwable cause, Object ... params) {
        this.log(40, message, cause, params);
    }

    @Override
    public LoggingBuilder atWarn() {
        return new DefaultLoggingBuilder(this, 40);
    }

    @Override
    public boolean isErrorEnable() {
        return this.isEnable(50);
    }

    @Override
    public void error(CharSequence message) {
        this.log(50, message);
    }

    @Override
    public void error(CharSequence message, Throwable cause) {
        this.log(50, message, cause);
    }

    @Override
    public void error(CharSequence message, Object ... params) {
        this.log(50, message, params);
    }

    @Override
    public void error(CharSequence message, Supplier<?> ... paramsSupplier) {
        this.log(50, message, paramsSupplier);
    }

    @Override
    public void error(CharSequence message, Throwable cause, Supplier<?> ... paramsSupplier) {
        this.log(50, message, cause, paramsSupplier);
    }

    @Override
    public void error(CharSequence message, Throwable cause, Object ... params) {
        this.log(50, message, cause, params);
    }

    @Override
    public LoggingBuilder atError() {
        return new DefaultLoggingBuilder(this, 50);
    }

    @Override
    public boolean isFatalEnable() {
        return this.isEnable(60);
    }

    @Override
    public void fatal(CharSequence message) {
        this.log(60, message);
    }

    @Override
    public void fatal(CharSequence message, Throwable cause) {
        this.log(60, message, cause);
    }

    @Override
    public void fatal(CharSequence message, Object ... params) {
        this.log(60, message, params);
    }

    @Override
    public void fatal(CharSequence message, Supplier<?> ... paramsSupplier) {
        this.log(60, message, paramsSupplier);
    }

    @Override
    public void fatal(CharSequence message, Throwable cause, Supplier<?> ... paramsSupplier) {
        this.log(60, message, cause, paramsSupplier);
    }

    @Override
    public void fatal(CharSequence message, Throwable cause, Object ... params) {
        this.log(60, message, cause, params);
    }

    @Override
    public LoggingBuilder atFatal() {
        return new DefaultLoggingBuilder(this, 60);
    }
}

