/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.mail;

import jakarta.mail.Address;
import jakarta.mail.FetchProfile;
import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.search.FlagTerm;
import jakarta.mail.search.SearchTerm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.seppiko.commons.mail.MailMessage;

public class JakartaMailReceiver {
    private Session session;
    private String username;
    private String password;

    private void setSession(Session session) {
        this.session = session;
    }

    public void setUser(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public JakartaMailReceiver(Session session) {
        this.setSession(session);
    }

    public ArrayList<MailMessage> receive(String folderName) throws IllegalAccessException, MessagingException, IOException {
        if (this.session == null) {
            throw new IllegalAccessException("Session must be not NULL");
        }
        Store store = this.session.getStore();
        store.connect(this.username, this.password);
        Folder folder = JakartaMailReceiver.getFolder(store, folderName);
        Message[] messages = folder.getMessages();
        ArrayList<MailMessage> mails = new ArrayList<MailMessage>();
        for (Message message : messages) {
            mails.add(JakartaMailReceiver.parseMailMessage(message));
            message.setFlag(Flags.Flag.SEEN, true);
        }
        folder.close();
        store.close();
        return mails;
    }

    private static Folder getFolder(Store store, String folderName) throws MessagingException {
        Folder inbox = store.getFolder(folderName);
        inbox.open(2);
        FetchProfile profile = new FetchProfile();
        profile.add(FetchProfile.Item.ENVELOPE);
        FlagTerm ft = new FlagTerm(new Flags(Flags.Flag.RECENT), false);
        Message[] messages = inbox.search((SearchTerm)ft);
        inbox.fetch(messages, profile);
        return inbox;
    }

    private static MailMessage parseMailMessage(Message message) throws MessagingException, IOException {
        MailMessage mail = new MailMessage();
        String from = MimeUtility.decodeText((String)message.getFrom()[0].toString());
        mail.setFrom(new InternetAddress(from));
        Address[] recipients = message.getAllRecipients();
        if (recipients != null) {
            ArrayList<InternetAddress> toIA = new ArrayList<InternetAddress>();
            ArrayList<InternetAddress> ccIA = new ArrayList<InternetAddress>();
            ArrayList<InternetAddress> bccIA = new ArrayList<InternetAddress>();
            for (Address recipient : recipients) {
                if (recipient == null) continue;
                if (Message.RecipientType.TO.toString().equals(recipient.getType())) {
                    String to = MimeUtility.decodeText((String)recipient.toString());
                    toIA.add(new InternetAddress(to));
                }
                if (Message.RecipientType.CC.toString().equals(recipient.getType())) {
                    String cc = MimeUtility.decodeText((String)recipient.toString());
                    ccIA.add(new InternetAddress(cc));
                }
                if (!Message.RecipientType.BCC.toString().equals(recipient.getType())) continue;
                String bcc = MimeUtility.decodeText((String)recipient.toString());
                bccIA.add(new InternetAddress(bcc));
            }
            if (toIA.size() > 0) {
                mail.setTo((InternetAddress[])JakartaMailReceiver.convert(toIA));
            }
            if (ccIA.size() > 0) {
                mail.setCc((InternetAddress[])JakartaMailReceiver.convert(ccIA));
            }
            if (bccIA.size() > 0) {
                mail.setBcc((InternetAddress[])JakartaMailReceiver.convert(bccIA));
            }
        }
        String replyTo = MimeUtility.decodeText((String)message.getReplyTo()[0].toString());
        mail.setReplyTo(new InternetAddress(replyTo));
        mail.setSubject(message.getSubject());
        mail.setText(String.valueOf(message.getContent()));
        return mail;
    }

    private static <T> T[] convert(List<T> list) {
        Object[] ts = new Object[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ts[i] = list.get(i);
        }
        return ts;
    }
}

