/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.mail;

import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.nio.charset.StandardCharsets;

public class MimeMessageHelper {
    private final MimeMessage message;
    private boolean validateAddresses;
    private String encoding = StandardCharsets.UTF_8.name();

    public MimeMessageHelper(MimeMessage message) throws MessagingException {
        this.message = message;
        this.validateAddresses = false;
        this.createMimeMultiparts(message);
    }

    private void createMimeMultiparts(MimeMessage message) throws MessagingException {
        MimeMultipart rootMixedMultipart = new MimeMultipart("mixed");
        message.setContent((Multipart)rootMixedMultipart);
        MimeMultipart nestedRelatedMultipart = new MimeMultipart("related");
        MimeBodyPart relatedBodyPart = new MimeBodyPart();
        relatedBodyPart.setContent((Multipart)nestedRelatedMultipart);
        rootMixedMultipart.addBodyPart((BodyPart)relatedBodyPart);
    }

    public void setFrom(String from) throws MessagingException {
        this.setFrom(InternetAddress.parse((String)from)[0]);
    }

    public void setFrom(InternetAddress from) throws MessagingException {
        this.validateAddress(from);
        this.message.setFrom((Address)from);
    }

    public void setTo(String to) throws MessagingException {
        this.setTo(InternetAddress.parse((String)to));
    }

    public void setTo(InternetAddress[] to) throws MessagingException {
        this.validateAddresses(to);
        this.message.setRecipients(Message.RecipientType.TO, (Address[])to);
    }

    public void setCc(String cc) throws MessagingException {
        this.setCc(InternetAddress.parse((String)cc));
    }

    public void setCc(InternetAddress[] cc) throws MessagingException {
        this.validateAddresses(cc);
        this.message.setRecipients(Message.RecipientType.CC, (Address[])cc);
    }

    public void setBcc(String bcc) throws MessagingException {
        this.setCc(InternetAddress.parse((String)bcc));
    }

    public void setBcc(InternetAddress[] bcc) throws MessagingException {
        this.validateAddresses(bcc);
        this.message.setRecipients(Message.RecipientType.BCC, (Address[])bcc);
    }

    public void setReplyTo(InternetAddress[] replyTo) throws MessagingException {
        this.validateAddresses(replyTo);
        this.message.setReplyTo((Address[])replyTo);
    }

    public void setReplyTo(InternetAddress replyTo) throws MessagingException {
        this.setReplyTo(new InternetAddress[]{replyTo});
    }

    public void setSubject(String subject) throws MessagingException {
        this.message.setSubject(subject, this.encoding);
    }

    public void setText(String text) throws MessagingException {
        this.setText(text, false);
    }

    public void setText(String text, boolean isHtml) throws MessagingException {
        if (isHtml) {
            this.message.setText(text, this.encoding, "html");
        } else {
            this.message.setText(text, this.encoding);
        }
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public MimeMessage getMimeMessage() {
        return this.message;
    }

    public boolean isValidateAddresses() {
        return this.validateAddresses;
    }

    public void setValidateAddresses(boolean validateAddresses) {
        this.validateAddresses = validateAddresses;
    }

    private void validateAddress(InternetAddress address) throws AddressException {
        if (this.isValidateAddresses()) {
            address.validate();
        }
    }

    private void validateAddresses(InternetAddress[] addresses) throws AddressException {
        for (InternetAddress address : addresses) {
            this.validateAddress(address);
        }
    }
}

