/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.mail;

import jakarta.mail.Address;
import jakarta.mail.FetchProfile;
import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.UIDFolder;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.search.FlagTerm;
import jakarta.mail.search.SearchTerm;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.seppiko.commons.mail.MailMessage;

public class JakartaMailReceiver {
    private Session session;
    private String protocol;
    private String username;
    private String password;

    private void setSession(Session session) {
        this.session = session;
        this.protocol = session.getProperty("mail.store.protocol");
    }

    public void setUser(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public JakartaMailReceiver(Session session) {
        this.setSession(session);
    }

    public ArrayList<MailMessage> receive(String folderName) throws IllegalAccessException, MessagingException, IOException {
        if (this.session == null) {
            throw new IllegalAccessException("Session must be not NULL");
        }
        Store store = this.session.getStore();
        store.connect(this.username, this.password);
        Folder folder = this.getFolder(store, folderName);
        Message[] messages = folder.getMessages();
        ArrayList<MailMessage> mails = new ArrayList<MailMessage>();
        for (Message message : messages) {
            mails.add(this.parseMailMessage(message));
            message.setFlag(Flags.Flag.SEEN, true);
        }
        folder.close();
        store.close();
        return mails;
    }

    private Folder getFolder(Store store, String folderName) throws MessagingException {
        Flags.Flag flag;
        FetchProfile profile = new FetchProfile();
        profile.add((FetchProfile.Item)UIDFolder.FetchProfileItem.UID);
        Folder inbox = store.getFolder(folderName);
        if (this.protocol.startsWith("imap")) {
            inbox.open(2);
            flag = Flags.Flag.RECENT;
        } else if (this.protocol.startsWith("pop3")) {
            inbox.open(1);
            flag = Flags.Flag.SEEN;
        } else {
            throw new IllegalArgumentException("Jakarta Mail illegal store protocol");
        }
        FlagTerm ft = new FlagTerm(new Flags(flag), false);
        Message[] messages = inbox.search((SearchTerm)ft);
        inbox.fetch(messages, profile);
        return inbox;
    }

    private MailMessage parseMailMessage(Message message) throws MessagingException, IOException {
        MailMessage mail = new MailMessage();
        String from = MimeUtility.decodeText((String)message.getFrom()[0].toString());
        mail.setFrom(new InternetAddress(from));
        Address[] recipients = message.getAllRecipients();
        if (recipients != null) {
            ArrayList<InternetAddress> toIA = new ArrayList<InternetAddress>();
            ArrayList<InternetAddress> ccIA = new ArrayList<InternetAddress>();
            ArrayList<InternetAddress> bccIA = new ArrayList<InternetAddress>();
            for (Address recipient : recipients) {
                if (recipient == null) continue;
                if (Message.RecipientType.TO.toString().equals(recipient.getType())) {
                    String to = MimeUtility.decodeText((String)recipient.toString());
                    toIA.add(new InternetAddress(to));
                }
                if (Message.RecipientType.CC.toString().equals(recipient.getType())) {
                    String cc = MimeUtility.decodeText((String)recipient.toString());
                    ccIA.add(new InternetAddress(cc));
                }
                if (!Message.RecipientType.BCC.toString().equals(recipient.getType())) continue;
                String bcc = MimeUtility.decodeText((String)recipient.toString());
                bccIA.add(new InternetAddress(bcc));
            }
            if (toIA.size() > 0) {
                mail.setTo((InternetAddress[])this.convert(toIA));
            }
            if (ccIA.size() > 0) {
                mail.setCc((InternetAddress[])this.convert(ccIA));
            }
            if (bccIA.size() > 0) {
                mail.setBcc((InternetAddress[])this.convert(bccIA));
            }
        }
        String replyTo = MimeUtility.decodeText((String)message.getReplyTo()[0].toString());
        mail.setReplyTo(new InternetAddress(replyTo));
        ZoneId zoneId = ZoneId.of("UTC");
        ZonedDateTime sent = message.getSentDate().toInstant().atZone(zoneId);
        mail.setSentTimestamp(sent);
        ZonedDateTime received = message.getReceivedDate().toInstant().atZone(zoneId);
        mail.setReceivedTimestamp(received);
        mail.setSubject(message.getSubject());
        mail.setText(String.valueOf(message.getContent()));
        return mail;
    }

    private <T> T[] convert(List<T> list) {
        Object[] ts = new Object[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ts[i] = list.get(i);
        }
        return ts;
    }
}

