/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.mail;

import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.MimeMessage;
import java.time.Clock;
import java.util.Date;
import org.seppiko.commons.mail.MailMessage;
import org.seppiko.commons.mail.MimeMessageHelper;

public class JakartaMailSender {
    private Session session;
    private String username;
    private String password;

    private void setSession(Session session) {
        this.session = session;
    }

    public void setUser(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public JakartaMailSender(Session session) {
        this.setSession(session);
    }

    public MimeMessageHelper createMimeMessage() throws MessagingException {
        return new MimeMessageHelper(new MimeMessage(this.session));
    }

    public void send(MailMessage message) throws MessagingException, IllegalAccessException {
        MimeMessageHelper helper = this.createMimeMessage();
        if (message.getFrom() == null || message.getTo() == null || message.getSubject() == null || message.getText() == null) {
            throw new IllegalAccessException("From \\ To \\ Subject and Text must be NOT null");
        }
        String encoding = String.valueOf(this.session.getProperties().get("mail.encoding"));
        helper.setEncoding(encoding);
        helper.setFrom(message.getFrom());
        helper.setTo(message.getTo());
        if (message.getCc() != null) {
            helper.setCc(message.getCc());
        }
        if (message.getBcc() != null) {
            helper.setBcc(message.getBcc());
        }
        if (message.getReplyTo() != null) {
            helper.setReplyTo(message.getReplyTo());
        }
        helper.setSubject(message.getSubject());
        helper.setText(message.getText());
        this.send(helper.getMimeMessage());
    }

    public void send(MimeMessage message) throws MessagingException, IllegalAccessException {
        if (this.session == null) {
            throw new IllegalAccessException("Session must be not NULL");
        }
        Transport trans = this.session.getTransport();
        if ("".equals(this.username)) {
            this.username = null;
            if ("".equals(this.password)) {
                this.password = null;
            }
        }
        trans.connect(this.username, this.password);
        if (message.getSentDate() == null) {
            message.setSentDate(new Date(Clock.systemUTC().millis()));
        }
        String messageId = message.getMessageID();
        message.saveChanges();
        if (messageId != null) {
            message.setHeader("Message-ID", messageId);
        }
        trans.sendMessage((Message)message, message.getAllRecipients());
        trans.close();
    }
}

