/*
 * Copyright 2020 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.seppiko.commons.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

/**
 * Proxy factory
 *
 * @author Leonard Woo
 */
public class ProxyFactoryUtil {

  /**
   * call interface new instance from proxy
   *
   * @param clazz interface class
   * @param handler interface method invoke
   * @param <T> interface class type
   * @return interface method invoke return object
   */
  @SuppressWarnings("unchecked")
  public static <T> T newInstance(Class<T> clazz, ProxyHandler<T> handler) {
    return (T) Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{ clazz }, handler);
  }

  /**
   * interface proxy implement class interface
   *
   * @param <T> interface class type
   */
  public interface ProxyHandler<T> extends InvocationHandler {
  }
}
