/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.http;

import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.net.ssl.SSLSession;
import org.seppiko.commons.utils.http.HttpClientException;

public class AsyncHttpClientUtil {
    public static HttpResponse<String> getAsyncResponseString(HttpRequest req, InetSocketAddress proxy) throws HttpClientException {
        CompletableFuture resp = proxy == null ? AsyncHttpClientUtil.getAsyncResponseRaw(req, HttpResponse.BodyHandlers.ofString()) : AsyncHttpClientUtil.getAsyncResponseProxyRaw(req, HttpResponse.BodyHandlers.ofString(), proxy);
        try {
            return AsyncHttpClientUtil.httpResponse(resp);
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new HttpClientException("Response exception", ex);
        }
    }

    public static HttpResponse<byte[]> getAsyncResponseByteArray(HttpRequest req, InetSocketAddress proxy) throws HttpClientException {
        CompletableFuture resp = proxy == null ? AsyncHttpClientUtil.getAsyncResponseRaw(req, HttpResponse.BodyHandlers.ofByteArray()) : AsyncHttpClientUtil.getAsyncResponseProxyRaw(req, HttpResponse.BodyHandlers.ofByteArray(), proxy);
        try {
            return AsyncHttpClientUtil.httpResponse(resp);
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new HttpClientException("Response exception", ex);
        }
    }

    public static HttpResponse<InputStream> getAsyncResponseInputStream(HttpRequest req, InetSocketAddress proxy) throws HttpClientException {
        CompletableFuture resp = proxy == null ? AsyncHttpClientUtil.getAsyncResponseRaw(req, HttpResponse.BodyHandlers.ofInputStream()) : AsyncHttpClientUtil.getAsyncResponseProxyRaw(req, HttpResponse.BodyHandlers.ofInputStream(), proxy);
        try {
            return AsyncHttpClientUtil.httpResponse(resp);
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new HttpClientException("Response exception", ex);
        }
    }

    private static <T> HttpResponse<T> httpResponse(final CompletableFuture<HttpResponse<T>> resp) throws InterruptedException, ExecutionException {
        return new HttpResponse<T>(){

            @Override
            public int statusCode() {
                return (Integer)((CompletableFuture)resp.thenApply(HttpResponse::statusCode)).get();
            }

            @Override
            public HttpRequest request() {
                return (HttpRequest)((CompletableFuture)resp.thenApply(HttpResponse::request)).get();
            }

            @Override
            public Optional<HttpResponse<T>> previousResponse() {
                return (Optional)((CompletableFuture)resp.thenApply(HttpResponse::previousResponse)).get();
            }

            @Override
            public HttpHeaders headers() {
                return (HttpHeaders)((CompletableFuture)resp.thenApply(HttpResponse::headers)).get();
            }

            @Override
            public T body() {
                return ((CompletableFuture)resp.thenApply(HttpResponse::body)).get();
            }

            @Override
            public Optional<SSLSession> sslSession() {
                return (Optional)((CompletableFuture)resp.thenApply(HttpResponse::sslSession)).get();
            }

            @Override
            public URI uri() {
                return (URI)((CompletableFuture)resp.thenApply(HttpResponse::uri)).get();
            }

            @Override
            public HttpClient.Version version() {
                return (HttpClient.Version)((Object)((CompletableFuture)resp.thenApply(HttpResponse::version)).get());
            }
        };
    }

    private static <T> CompletableFuture<HttpResponse<T>> getAsyncResponseRaw(HttpRequest req, HttpResponse.BodyHandler<T> responseBodyHandler) {
        return HttpClient.newHttpClient().sendAsync(req, responseBodyHandler);
    }

    private static <T> CompletableFuture<HttpResponse<T>> getAsyncResponseProxyRaw(HttpRequest req, HttpResponse.BodyHandler<T> responseBodyHandler, InetSocketAddress proxy) {
        return HttpClient.newBuilder().proxy(ProxySelector.of(proxy)).build().sendAsync(req, responseBodyHandler);
    }
}

